<?php
// This is just for testing - remove this file after testing is complete
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Import PHPMailer classes at the top level
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Include necessary files
require_once 'config/database.php'; // Include your config file that has SMTP settings
require_once 'vendor/autoload.php'; // Load PHPMailer from vendor directory

// Test email
$to = 'mbkoncepts@gmail.com';
$subject = 'Test Email from BlueSeal Bank';
$body = '<h1>Test Email</h1><p>This is a test email to verify SMTP settings.</p>';

echo "<h1>Testing Email Sending</h1>";
echo "<p>Attempting to send test email to: $to</p>";

echo "<h2>SMTP Configuration:</h2>";
echo "<ul>";
echo "<li>SMTP Host: " . (defined('SMTP_HOST') ? SMTP_HOST : 'Not defined') . "</li>";
echo "<li>SMTP Port: " . (defined('SMTP_PORT') ? SMTP_PORT : 'Not defined') . "</li>";
echo "<li>SMTP Username: " . (defined('SMTP_USERNAME') ? SMTP_USERNAME : 'Not defined') . "</li>";
echo "<li>SMTP Password: " . (defined('SMTP_PASSWORD') ? (strlen(SMTP_PASSWORD) > 0 ? '******' : 'Empty') : 'Not defined') . "</li>";
echo "<li>SMTP Secure: " . (defined('SMTP_SECURE') ? SMTP_SECURE : 'Not defined') . "</li>";
echo "<li>Mail From Address: " . (defined('MAIL_FROM_ADDRESS') ? MAIL_FROM_ADDRESS : 'Not defined') . "</li>";
echo "<li>Mail From Name: " . (defined('MAIL_FROM_NAME') ? MAIL_FROM_NAME : 'Not defined') . "</li>";
echo "</ul>";

// Create a function to test SMTP email
function testSMTPEmail($to, $subject, $body) {
    // Default values
    $bankName = defined('BANK_NAME') ? BANK_NAME : 'BlueSeal Bank';
    $fromName = defined('MAIL_FROM_NAME') ? MAIL_FROM_NAME : $bankName;
    $fromEmail = defined('MAIL_FROM_ADDRESS') ? MAIL_FROM_ADDRESS : 'noreply@yourdomain.com';
    
    // SMTP Configuration
    $smtpHost = defined('SMTP_HOST') ? SMTP_HOST : 'smtp.gmail.com';
    $smtpPort = defined('SMTP_PORT') ? SMTP_PORT : 587;
    $smtpUsername = defined('SMTP_USERNAME') ? SMTP_USERNAME : 'your-email@gmail.com';
    $smtpPassword = defined('SMTP_PASSWORD') ? SMTP_PASSWORD : 'your-password';
    $smtpSecure = defined('SMTP_SECURE') ? SMTP_SECURE : 'tls';
    
    // Create a new PHPMailer instance
    $mail = new PHPMailer(true);
    
    try {
        // Server settings
        $mail->SMTPDebug = 2;                      // Enable verbose debug output
        $mail->Debugoutput = function($str, $level) {
            echo "<pre style='margin: 0; padding: 0;'>$str</pre>";
        };
        $mail->isSMTP();                           // Send using SMTP
        $mail->Host       = $smtpHost;             // SMTP server
        $mail->SMTPAuth   = true;                  // Enable SMTP authentication
        $mail->Username   = $smtpUsername;         // SMTP username
        $mail->Password   = $smtpPassword;         // SMTP password
        $mail->SMTPSecure = $smtpSecure;           // Enable TLS encryption
        $mail->Port       = $smtpPort;             // TCP port to connect to
        
        // Add SSL options to avoid certificate verification issues
        $mail->SMTPOptions = [
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            ]
        ];
        
        // Recipients
        $mail->setFrom($fromEmail, $fromName);
        $mail->addAddress($to);                    // Add a recipient
        
        // Content
        $mail->isHTML(true);                       // Set email format to HTML
        $mail->Subject = $subject;
        $mail->Body    = $body;
        
        // Send the email
        $result = $mail->send();
        echo "<p style='color:green'>Email sent successfully!</p>";
        return $result;
    } catch (Exception $e) {
        echo "<p style='color:red'>Message could not be sent. Mailer Error: {$mail->ErrorInfo}</p>";
        return false;
    }
}

// Try to send the test email
try {
    $result = testSMTPEmail($to, $subject, $body);
    if ($result) {
        echo "<p style='color:green'>Email sent successfully!</p>";
    } else {
        echo "<p style='color:red'>Failed to send email. Check the error messages above.</p>";
    }
} catch (Exception $e) {
    echo "<p style='color:red'>Error: " . $e->getMessage() . "</p>";
}
?>
