<?php
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Account - BlueSeal Bank</title>
    
    <!-- CSS Dependencies -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.0.7/css/boxicons.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

    <style>
        /* Root Variables */
        :root {
            --primary-color: #4f46e5;
            --primary-light: #eef2ff;
            --primary-dark: #4338ca;
            --success-color: #059669;
            --danger-color: #dc2626;
            --warning-color: #ea580c;
            --info-color: #0284c7;
            --background-color: #f8fafc;
            --gray-color: #64748b;
            --border-color: #e2e8f0;
            --text-color: #1e293b;
            --text-muted: #64748b;
        }

        body {
            font-family: 'Poppins', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #4338ca, #6366F1);
            min-height: 100vh;
            color: var(--text-color);
            padding: 2rem 0;
            line-height: 1.5;
        }

        .register-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            overflow: hidden;
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
        }

        .register-header {
            background: linear-gradient(to right, var(--primary-color), var(--primary-dark));
            padding: 2rem;
            color: white;
            text-align: center;
            position: relative;
        }

        .register-header::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(to right, rgba(255,255,255,0.2), transparent);
        }

        .register-body {
            padding: 2rem;
        }

        /* Progress Steps */
        .step-progress {
            display: flex;
            justify-content: space-between;
            margin: 0 auto 2rem;
            max-width: 800px;
            position: relative;
            padding: 0 20px;
        }

        .step-progress::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 40px;
            right: 40px;
            height: 2px;
            background: #e2e8f0;
            transform: translateY(-50%);
            z-index: 1;
        }

        .step-item {
            position: relative;
            z-index: 2;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: white;
            border: 2px solid #e2e8f0;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .step-item.active {
            border-color: var(--primary-color);
            background: var(--primary-color);
            color: white;
        }

        .step-item.completed {
            border-color: var(--success-color);
            background: var(--success-color);
            color: white;
        }

        .step-label {
            position: absolute;
            top: 100%;
            left: 50%;
            transform: translateX(-50%);
            margin-top: 8px;
            font-size: 0.875rem;
            color: var(--gray-color);
            white-space: nowrap;
        }

        /* Form Sections */
        .form-section {
            display: none;
            opacity: 0;
            transform: translateY(20px);
            transition: all 0.3s ease;
        }

        .form-section.active {
            display: block;
            opacity: 1;
            transform: translateY(0);
        }

        /* Form Controls - Fixed Styling */
        .form-label {
            font-weight: 500;
            color: var(--text-color);
            margin-bottom: 0.5rem;
            display: block;
        }

        .form-control, .form-select {
            display: block;
            width: 100%;
            padding: 0.75rem 1rem;
            font-size: 1rem;
            font-weight: 400;
            line-height: 1.5;
            color: var(--text-color);
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid var(--border-color);
            border-radius: 0.5rem;
            transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            outline: 0;
            box-shadow: 0 0 0 0.25rem rgba(79, 70, 229, 0.1);
        }

        .form-control::placeholder {
            color: #a0aec0;
            opacity: 1;
        }

        .form-text {
            margin-top: 0.25rem;
            font-size: 0.875rem;
            color: var(--text-muted);
        }

        .form-check {
            display: block;
            min-height: 1.5rem;
            padding-left: 1.5em;
            margin-bottom: 0.125rem;
        }

        .form-check-input {
            width: 1em;
            height: 1em;
            margin-top: 0.25em;
            vertical-align: top;
            background-color: #fff;
            background-repeat: no-repeat;
            background-position: center;
            background-size: contain;
            border: 1px solid rgba(0, 0, 0, 0.25);
            appearance: none;
        }

        .form-check-input[type="checkbox"] {
            border-radius: 0.25em;
        }

        .form-check-input:checked {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        .form-check-label {
            margin-bottom: 0;
        }

        /* Input Groups */
        .input-group {
            position: relative;
            display: flex;
            flex-wrap: wrap;
            align-items: stretch;
            width: 100%;
        }

        .input-group > .form-control,
        .input-group > .form-select {
            position: relative;
            flex: 1 1 auto;
            width: 1%;
            min-width: 0;
        }

        .input-group > .form-control:not(:last-child) {
            border-top-right-radius: 0;
            border-bottom-right-radius: 0;
        }

        .input-group-text, 
        .input-group .btn {
            display: flex;
            align-items: center;
            padding: 0.75rem 1rem;
            font-size: 1rem;
            font-weight: 400;
            line-height: 1.5;
            text-align: center;
            white-space: nowrap;
            border: 1px solid var(--border-color);
        }

        .input-group .btn {
            border-top-left-radius: 0;
            border-bottom-left-radius: 0;
        }

        /* Section Titles */
        .profile-section-title {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            color: var(--primary-color);
        }

        .profile-section-title i {
            margin-right: 0.75rem;
            font-size: 1.5rem;
        }

        /* Profile Upload */
        .profile-upload {
            display: flex;
            align-items: center;
            gap: 1.5rem;
            margin-bottom: 1.5rem;
        }

        .profile-preview {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            overflow: hidden;
            border: 3px solid var(--border-color);
            position: relative;
            background-color: #f8fafc;
        }

        .profile-preview img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .upload-btn {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(0,0,0,0.5);
            color: white;
            padding: 0.25rem;
            font-size: 0.75rem;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .upload-btn:hover {
            background: rgba(0,0,0,0.7);
        }

        /* File Upload */
        .file-upload {
            position: relative;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 2rem;
            border: 2px dashed var(--border-color);
            border-radius: 0.5rem;
            background-color: #f8fafc;
            transition: all 0.3s ease;
            cursor: pointer;
            margin-bottom: 1rem;
        }

        .file-upload:hover {
            border-color: var(--primary-color);
            background-color: var(--primary-light);
        }

        .file-upload input[type="file"] {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            opacity: 0;
            cursor: pointer;
        }

        .file-upload i {
            font-size: 2rem;
            color: var(--primary-color);
            margin-bottom: 0.5rem;
        }

        .file-upload-text {
            font-weight: 500;
            margin-bottom: 0.25rem;
        }

        .file-upload-hint {
            font-size: 0.8rem;
            color: var(--gray-color);
        }

        .file-preview {
            margin-top: 1rem;
            display: none;
        }

        .file-preview.show {
            display: block;
        }

        .file-name {
            display: inline-block;
            padding: 0.25rem 0.75rem;
            background-color: var(--primary-light);
            color: var(--primary-color);
            border-radius: 0.25rem;
            font-size: 0.875rem;
            font-weight: 500;
        }

        /* Buttons */
        .btn {
            display: inline-block;
            font-weight: 500;
            line-height: 1.5;
            color: #212529;
            text-align: center;
            text-decoration: none;
            vertical-align: middle;
            cursor: pointer;
            user-select: none;
            background-color: transparent;
            border: 1px solid transparent;
            padding: 0.75rem 1.5rem;
            font-size: 1rem;
            border-radius: 0.5rem;
            transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, 
                        border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
        }

        .btn-primary {
            color: #fff;
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        .btn-primary:hover {
            background-color: var(--primary-dark);
            border-color: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }

        .btn-outline-secondary {
            color: var(--gray-color);
            border-color: var(--border-color);
        }

        .btn-outline-secondary:hover {
            color: var(--text-color);
            background-color: #f8fafc;
            border-color: var(--gray-color);
        }

        /* Form Footer */
        .form-footer {
            padding: 1.5rem 2rem;
            border-top: 1px solid var(--border-color);
            background-color: #f8fafc;
            display: flex;
            justify-content: space-between;
            margin-top: 2rem;
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .fade-in {
            animation: fadeIn 0.5s ease forwards;
        }

        /* Radio and Checkbox Styles */
        .custom-radio-group {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .custom-radio-btn {
            flex: 1;
            min-width: 120px;
        }

        .custom-radio-btn input[type="radio"] {
            display: none;
        }

        .custom-radio-btn label {
            display: block;
            padding: 1rem;
            text-align: center;
            border: 1px solid var(--border-color);
            border-radius: 0.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .custom-radio-btn input[type="radio"]:checked + label {
            background-color: var(--primary-light);
            border-color: var(--primary-color);
            color: var(--primary-color);
            font-weight: 500;
        }

        .custom-radio-btn label:hover {
            border-color: var(--primary-color);
        }

        /* Form Section Animation */
        .form-section {
            transition: opacity 0.4s ease, transform 0.4s ease;
        }

        .form-section.active {
            animation: fadeIn 0.5s ease forwards;
        }

        /* Form Validation Styles */
        .is-invalid {
            border-color: var(--danger-color) !important;
        }

        .invalid-feedback {
            display: none;
            width: 100%;
            margin-top: 0.25rem;
            font-size: 0.875em;
            color: var(--danger-color);
        }

        .was-validated .form-control:invalid,
        .form-control.is-invalid {
            border-color: var(--danger-color);
            padding-right: calc(1.5em + 0.75rem);
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e");
            background-repeat: no-repeat;
            background-position: right calc(0.375em + 0.1875rem) center;
            background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);
        }

        .was-validated .form-control:invalid:focus,
        .form-control.is-invalid:focus {
            border-color: var(--danger-color);
            box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);
        }

        .was-validated .form-select:invalid,
        .form-select.is-invalid {
            border-color: var(--danger-color);
        }

        .was-validated .form-select:invalid:focus,
        .form-select.is-invalid:focus {
            border-color: var(--danger-color);
            box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);
        }

        /* Spacing Utilities */
        .mb-1 { margin-bottom: 0.25rem !important; }
        .mb-2 { margin-bottom: 0.5rem !important; }
        .mb-3 { margin-bottom: 1rem !important; }
        .mb-4 { margin-bottom: 1.5rem !important; }
        .mt-1 { margin-top: 0.25rem !important; }
        .mt-2 { margin-top: 0.5rem !important; }
        .mt-3 { margin-top: 1rem !important; }
        .mt-4 { margin-top: 1.5rem !important; }

        /* Responsive Adjustments */
        @media (max-width: 768px) {
            .register-body {
                padding: 1.5rem;
            }

            .step-progress {
                max-width: 100%;
                padding: 0 10px;
            }

            .step-label {
                font-size: 0.75rem;
            }

            .form-footer {
                flex-direction: column;
                gap: 1rem;
            }

            .form-footer .btn {
                width: 100%;
            }
            
            .row {
                margin-right: -0.5rem;
                margin-left: -0.5rem;
            }
            
            .col-md-6 {
                padding-right: 0.5rem;
                padding-left: 0.5rem;
            }
        }

        /* Fix for Bootstrap Row and Column Spacing */
        .row {
            display: flex;
            flex-wrap: wrap;
            margin-right: -0.75rem;
            margin-left: -0.75rem;
        }

        .col-md-6, .col-md-4, .col-md-12, .col-12 {
            position: relative;
            width: 100%;
            padding-right: 0.75rem;
            padding-left: 0.75rem;
        }

        @media (min-width: 768px) {
            .col-md-4 {
                flex: 0 0 33.333333%;
                max-width: 33.333333%;
            }
            
            .col-md-6 {
                flex: 0 0 50%;
                max-width: 50%;
            }
            
            .col-md-12 {
                flex: 0 0 100%;
                max-width: 100%;
            }
        }

        .g-3 {
            --bs-gutter-y: 1rem;
            --bs-gutter-x: 1rem;
            margin-top: calc(-1 * var(--bs-gutter-y));
            margin-right: calc(-.5 * var(--bs-gutter-x));
            margin-left: calc(-.5 * var(--bs-gutter-x));
        }

        .g-3 > * {
            padding-right: calc(var(--bs-gutter-x) * .5);
            padding-left: calc(var(--bs-gutter-x) * .5);
            margin-top: var(--bs-gutter-y);
        }
    </style>
</head>
<body>
<div class="register-container">
    <div class="register-header">
        <img src="assets/images/logo.png" alt="Bank Logo" height="40" class="mb-3">
        <h3>Create Your Account</h3>
        <p class="mb-0">Fill in your details to get started</p>
    </div>

    <div class="register-body">
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php 
                    echo htmlspecialchars($_SESSION['error']); 
                    unset($_SESSION['error']); // Clear the error message
                ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Step Progress -->
        <div class="step-progress">
            <div class="step-item active" data-step="1">
                1
                <span class="step-label">Personal Info</span>
            </div>
            <div class="step-item" data-step="2">
                2
                <span class="step-label">Additional Info</span>
            </div>
            <div class="step-item" data-step="3">
                3
                <span class="step-label">Financial Profile</span>
            </div>
            <div class="step-item" data-step="4">
                4
                <span class="step-label">Documents</span>
            </div>
            <div class="step-item" data-step="5">
                5
                <span class="step-label">Account Setup</span>
            </div>
            <div class="step-item" data-step="6">
                6
                <span class="step-label">Security</span>
            </div>
        </div>

        <!-- Registration Form -->
        <form id="registrationForm" action="process_registration.php" method="POST" enctype="multipart/form-data" onsubmit="return handleSubmit(event)">

            <!-- Step 1: Personal Information -->
            <div class="form-section active" id="step1">
                <h3 class="profile-section-title"><i class='bx bx-user-circle'></i> Personal Information</h3>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="firstName" class="form-label">First Name</label>
                        <input type="text" class="form-control" id="firstName" name="firstName" placeholder="Enter first name" required>
                    </div>
                    <div class="col-md-6">
                        <label for="lastName" class="form-label">Last Name</label>
                        <input type="text" class="form-control" id="lastName" name="lastName" placeholder="Enter last name" required>
                    </div>
                    <div class="col-md-6">
                        <label for="email" class="form-label">Email Address</label>
                        <input type="email" class="form-control" id="email" name="email" placeholder="Enter email address" required>
                    </div>
                    <div class="col-md-6">
                        <label for="phone" class="form-label">Phone Number</label>
                        <input type="tel" class="form-control" id="phone" name="phone" placeholder="Enter phone number" required>
                    </div>
                    <div class="col-md-6">
                        <label for="dob" class="form-label">Date of Birth</label>
                        <input type="date" class="form-control" id="dob" name="dob" required>
                    </div>
                    <div class="col-md-6">
                        <label for="gender" class="form-label">Gender</label>
                        <select class="form-select" id="gender" name="gender" required>
                            <option value="">Select Gender</option>
                            <option value="male">Male</option>
                            <option value="female">Female</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="ssn" class="form-label">Social Security Number</label>
                        <input type="text" class="form-control" id="ssn" name="ssn" placeholder="XXX-XX-XXXX" required>
                    </div>
                    <div class="col-md-6">
                        <label for="mothersMaidenName" class="form-label">Mother's Maiden Name</label>
                        <input type="text" class="form-control" id="mothersMaidenName" name="mothersMaidenName" placeholder="Enter mother's maiden name" required>
                    </div>
                </div>

                <h3 class="profile-section-title mt-4"><i class='bx bx-map'></i> Address Information</h3>
                <div class="row g-3">
                    <div class="col-md-12">
                        <label for="address" class="form-label">Street Address</label>
                        <input type="text" class="form-control" id="address" name="address" placeholder="Enter street address" required>
                    </div>
                    <div class="col-md-4">
                        <label for="city" class="form-label">City</label>
                        <input type="text" class="form-control" id="city" name="city" placeholder="Enter city" required>
                    </div>
                    <div class="col-md-4">
                        <label for="state" class="form-label">State/Province</label>
                        <input type="text" class="form-control" id="state" name="state" placeholder="Enter state/province" required>
                    </div>
                    <div class="col-md-4">
                        <label for="zipCode" class="form-label">Zip/Postal Code</label>
                        <input type="text" class="form-control" id="zipCode" name="zipCode" placeholder="Enter zip/postal code" required>
                    </div>
                    <div class="col-md-12">
                        <label for="country" class="form-label">Country</label>
                        <select class="form-select" id="country" name="country" required>
                            <option value="">Select Country</option>
                            <!-- Countries will be populated by JavaScript -->
                        </select>
                    </div>
                </div>

                <div class="form-footer">
                    <div></div> <!-- Empty div for spacing -->
                    <button type="button" class="btn btn-primary" onclick="nextStep(1)">
                        Continue <i class='bx bx-right-arrow-alt'></i>
                    </button>
                </div>
            </div>

            <!-- Step 2: Additional Information -->
            <div class="form-section" id="step2">
                <h3 class="profile-section-title"><i class='bx bx-info-circle'></i> Additional Information</h3>
                
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="employmentStatus" class="form-label">Employment Status</label>
                        <select class="form-select" id="employmentStatus" name="employmentStatus" required>
                            <option value="">Select Status</option>
                            <option value="employed">Employed</option>
                            <option value="self-employed">Self-Employed</option>
                            <option value="student">Student</option>
                            <option value="retired">Retired</option>
                            <option value="unemployed">Unemployed</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="incomeSource" class="form-label">Primary Source of Income</label>
                        <select class="form-select" id="incomeSource" name="incomeSource" required>
                            <option value="">Select Source</option>
                            <option value="salary">Salary</option>
                            <option value="business">Business Income</option>
                            <option value="investments">Investments</option>
                            <option value="retirement">Retirement</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="occupation" class="form-label">Occupation</label>
                        <input type="text" class="form-control" id="occupation" name="occupation" placeholder="Enter occupation">
                    </div>
                    <div class="col-md-6">
                        <label for="employer" class="form-label">Employer Name</label>
                        <input type="text" class="form-control" id="employer" name="employer" placeholder="Enter employer name">
                    </div>
                </div>

                <h3 class="profile-section-title mt-4"><i class='bx bx-user-pin'></i> Next of Kin Details</h3>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="kinName" class="form-label">Full Name</label>
                        <input type="text" class="form-control" id="kinName" name="kinName" placeholder="Enter full name" required>
                    </div>
                    <div class="col-md-6">
                        <label for="kinRelationship" class="form-label">Relationship</label>
                        <select class="form-select" id="kinRelationship" name="kinRelationship" required>
                            <option value="">Select Relationship</option>
                            <option value="spouse">Spouse</option>
                            <option value="parent">Parent</option>
                            <option value="child">Child</option>
                            <option value="sibling">Sibling</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="kinEmail" class="form-label">Email Address</label>
                        <input type="email" class="form-control" id="kinEmail" name="kinEmail" placeholder="Enter email address" required>
                    </div>
                    <div class="col-md-6">
                        <label for="kinPhone" class="form-label">Phone Number</label>
                        <input type="tel" class="form-control" id="kinPhone" name="kinPhone" placeholder="Enter phone number" required>
                    </div>
                    <div class="col-12">
                        <label for="kinAddress" class="form-label">Address</label>
                                                <textarea class="form-control" id="kinAddress" name="kinAddress" placeholder="Enter address" style="height: 100px" required></textarea>
                    </div>
                </div>

                <div class="form-footer">
                    <button type="button" class="btn btn-outline-secondary" onclick="prevStep(2)">
                        <i class='bx bx-left-arrow-alt'></i> Back
                    </button>
                    <button type="button" class="btn btn-primary" onclick="nextStep(2)">
                        Continue <i class='bx bx-right-arrow-alt'></i>
                    </button>
                </div>
            </div>

            <!-- Step 3: Financial Profile -->
            <div class="form-section" id="step3">
                <h3 class="profile-section-title"><i class='bx bx-dollar-circle'></i> Financial Profile</h3>
                
                <div class="mb-4">
                    <label class="form-label">Do you have other bank accounts at other financial institutions?</label>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="hasOtherBankAccounts" id="hasOtherBankAccountsYes" value="yes">
                        <label class="form-check-label" for="hasOtherBankAccountsYes">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="hasOtherBankAccounts" id="hasOtherBankAccountsNo" value="no">
                        <label class="form-check-label" for="hasOtherBankAccountsNo">No</label>
                    </div>
                    <div class="mt-3 other-bank-accounts-container" style="display: none;">
                        <label for="otherBankAccounts" class="form-label">List the names of other financial institutions</label>
                        <textarea class="form-control" id="otherBankAccounts" name="otherBankAccounts" placeholder="Enter financial institution names" style="height: 100px"></textarea>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label">Do you have credit cards with other financial institutions?</label>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="hasOtherCreditCards" id="hasOtherCreditCardsYes" value="yes">
                        <label class="form-check-label" for="hasOtherCreditCardsYes">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="hasOtherCreditCards" id="hasOtherCreditCardsNo" value="no">
                        <label class="form-check-label" for="hasOtherCreditCardsNo">No</label>
                    </div>
                    <div class="mt-3 other-credit-cards-container" style="display: none;">
                        <div class="mb-3">
                            <label for="creditCardCount" class="form-label">How many credit cards do you have?</label>
                            <input type="number" class="form-control" id="creditCardCount" name="creditCardCount" placeholder="Enter number of credit cards">
                        </div>
                        <div>
                            <label for="otherCreditCards" class="form-label">List the names of financial institutions</label>
                            <textarea class="form-control" id="otherCreditCards" name="otherCreditCards" placeholder="Enter financial institution names" style="height: 100px"></textarea>
                        </div>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label">Do you have investment accounts with other financial institutions?</label>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="hasInvestmentAccounts" id="hasInvestmentAccountsYes" value="yes">
                        <label class="form-check-label" for="hasInvestmentAccountsYes">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="hasInvestmentAccounts" id="hasInvestmentAccountsNo" value="no">
                        <label class="form-check-label" for="hasInvestmentAccountsNo">No</label>
                    </div>
                    <div class="mt-3 investment-accounts-container" style="display: none;">
                        <label for="investmentAccounts" class="form-label">List the names of financial institutions</label>
                        <textarea class="form-control" id="investmentAccounts" name="investmentAccounts" placeholder="Enter financial institution names" style="height: 100px"></textarea>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label">Do you have a 401(k) account?</label>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="has401k" id="has401kYes" value="yes">
                        <label class="form-check-label" for="has401kYes">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="has401k" id="has401kNo" value="no">
                        <label class="form-check-label" for="has401kNo">No</label>
                    </div>
                    <div class="mt-3 401k-container" style="display: none;">
                        <label for="401kAccounts" class="form-label">List the names of financial institutions managing your 401(k)</label>
                        <textarea class="form-control" id="401kAccounts" name="401kAccounts" placeholder="Enter financial institution names" style="height: 100px"></textarea>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label">Do you have a home equity line of credit account?</label>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="hasHomeEquity" id="hasHomeEquityYes" value="yes">
                        <label class="form-check-label" for="hasHomeEquityYes">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="hasHomeEquity" id="hasHomeEquityNo" value="no">
                        <label class="form-check-label" for="hasHomeEquityNo">No</label>
                    </div>
                    <div class="mt-3 home-equity-container" style="display: none;">
                        <label for="homeEquityAccounts" class="form-label">List the names of financial institutions managing your home equity line of credit</label>
                        <textarea class="form-control" id="homeEquityAccounts" name="homeEquityAccounts" placeholder="Enter financial institution names" style="height: 100px"></textarea>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label">Do you have a business account?</label>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="hasBusinessAccount" id="hasBusinessAccountYes" value="yes">
                        <label class="form-check-label" for="hasBusinessAccountYes">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="hasBusinessAccount" id="hasBusinessAccountNo" value="no">
                        <label class="form-check-label" for="hasBusinessAccountNo">No</label>
                    </div>
                    <div class="mt-3 business-account-container" style="display: none;">
                        <label for="businessAccounts" class="form-label">List the names of financial institutions managing your business account</label>
                        <textarea class="form-control" id="businessAccounts" name="businessAccounts" placeholder="Enter financial institution names" style="height: 100px"></textarea>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label">Do you have a mortgage account?</label>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="hasMortgage" id="hasMortgageYes" value="yes">
                        <label class="form-check-label" for="hasMortgageYes">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="hasMortgage" id="hasMortgageNo" value="no">
                        <label class="form-check-label" for="hasMortgageNo">No</label>
                    </div>
                    <div class="mt-3 mortgage-container" style="display: none;">
                        <label for="mortgageAccounts" class="form-label">List the names of financial institutions managing your mortgage</label>
                        <textarea class="form-control" id="mortgageAccounts" name="mortgageAccounts" placeholder="Enter financial institution names" style="height: 100px"></textarea>
                    </div>
                </div>

                <div class="form-footer">
                    <button type="button" class="btn btn-outline-secondary" onclick="prevStep(3)">
                        <i class='bx bx-left-arrow-alt'></i> Back
                    </button>
                    <button type="button" class="btn btn-primary" onclick="nextStep(3)">
                        Continue <i class='bx bx-right-arrow-alt'></i>
                    </button>
                </div>
            </div>

            <!-- Step 4: Documents -->
            <div class="form-section" id="step4">
                <h3 class="profile-section-title"><i class='bx bx-file'></i> Document Upload</h3>
                
                <!-- Profile Picture -->
                <div class="mb-4">
                    <label class="form-label">Profile Picture</label>
                    <div class="profile-upload">
                        <div class="profile-preview">
                            <img src="assets/images/default-avatar.png" id="profilePreview" alt="Profile Preview">
                            <div class="upload-btn" onclick="document.getElementById('profilePicture').click()">
                                <i class='bx bx-camera'></i> Change
                            </div>
                            <input type="file" id="profilePicture" name="profilePicture" hidden accept="image/*" onchange="previewImage(this, 'profilePreview')">
                        </div>
                        <div class="upload-info">
                            <h6 class="mb-2">Profile Picture</h6>
                            <p class="text-muted mb-0">Upload a clear photo of yourself</p>
                            <small class="text-muted">Max file size: 5MB (JPG or PNG)</small>
                        </div>
                    </div>
                </div>

                <!-- Utility Bill Upload -->
                <div class="mb-4">
                    <label class="form-label">Utility Bill</label>
                    <div class="file-upload" onclick="document.getElementById('utilityBill').click()">
                        <i class='bx bx-upload'></i>
                        <div class="file-upload-text">Upload a copy of your home utility bill</div>
                        <div class="file-upload-hint">PDF, JPG or PNG format (Max 10MB)</div>
                        <input type="file" id="utilityBill" name="utilityBill" accept=".pdf,.jpg,.jpeg,.png" onchange="handleFileSelect(this, 'utilityBillName')">
                    </div>
                    <div class="file-preview" id="utilityBillPreview">
                        <span class="file-name" id="utilityBillName"></span>
                    </div>
                </div>

                <!-- ID Document Upload -->
                <div class="mb-4">
                    <label class="form-label">ID Document</label>
                    <div class="file-upload" onclick="document.getElementById('idDocument').click()">
                        <i class='bx bx-id-card'></i>
                        <div class="file-upload-text">Upload a government-issued ID</div>
                        <div class="file-upload-hint">Passport, Driver's License, or National ID (Max 10MB)</div>
                        <input type="file" id="idDocument" name="idDocument" accept=".pdf,.jpg,.jpeg,.png" onchange="handleFileSelect(this, 'idDocumentName')">
                    </div>
                    <div class="file-preview" id="idDocumentPreview">
                        <span class="file-name" id="idDocumentName"></span>
                    </div>
                </div>

                <div class="form-footer">
                    <button type="button" class="btn btn-outline-secondary" onclick="prevStep(4)">
                        <i class='bx bx-left-arrow-alt'></i> Back
                    </button>
                    <button type="button" class="btn btn-primary" onclick="nextStep(4)">
                        Continue <i class='bx bx-right-arrow-alt'></i>
                    </button>
                </div>
            </div>

            <!-- Step 5: Account Setup -->
            <div class="form-section" id="step5">
                <h3 class="profile-section-title"><i class='bx bx-bank'></i> Account Setup</h3>
                
                <div class="mb-4">
                    <label class="form-label">Select Account Type</label>
                    <div class="custom-radio-group">
                        <div class="custom-radio-btn">
                            <input type="radio" id="accountTypeSavings" name="accountType" value="savings" required>
                            <label for="accountTypeSavings">Savings Account</label>
                        </div>
                        <div class="custom-radio-btn">
                            <input type="radio" id="accountTypeChecking" name="accountType" value="checking" required>
                            <label for="accountTypeChecking">Checking Account</label>
                        </div>
                        <div class="custom-radio-btn">
                            <input type="radio" id="accountTypeBusiness" name="accountType" value="business" required>
                            <label for="accountTypeBusiness">Business Account</label>
                        </div>
                        <div class="custom-radio-btn">
                            <input type="radio" id="accountTypeIRA" name="accountType" value="ira" required>
                            <label for="accountTypeIRA">IRA</label>
                        </div>
                        <div class="custom-radio-btn">
                            <input type="radio" id="accountType401k" name="accountType" value="401k" required>
                            <label for="accountType401k">401(k)</label>
                        </div>
                        <div class="custom-radio-btn">
                            <input type="radio" id="accountTypeEscrow" name="accountType" value="escrow" required>
                            <label for="accountTypeEscrow">Escrow</label>
                        </div>
                        <div class="custom-radio-btn">
                            <input type="radio" id="accountTypeBrokerage" name="accountType" value="brokerage" required>
                            <label for="accountTypeBrokerage">Brokerage</label>
                        </div>
                        <div class="custom-radio-btn">
                            <input type="radio" id="accountTypeCD" name="accountType" value="cd" required>
                            <label for="accountTypeCD">Certificate of Deposit (CD)</label>
                        </div>
                    </div>
                </div>

                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="currency" class="form-label">Primary Currency</label>
                        <select class="form-select" id="currency" name="currency" required>
                            <option value="">Select Currency</option>
                            <option value="USD">US Dollar (USD)</option>
                            <option value="EUR">Euro (EUR)</option>
                            <option value="GBP">British Pound (GBP)</option>
                            <option value="CAD">Canadian Dollar (CAD)</option>
                            <option value="AUD">Australian Dollar (AUD)</option>
                            <option value="JPY">Japanese Yen (JPY)</option>
                            <option value="CHF">Swiss Franc (CHF)</option>
                            <option value="CNY">Chinese Yuan (CNY)</option>
                            <option value="INR">Indian Rupee (INR)</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="initialDeposit" class="form-label">Expected Initial Deposit</label>
                        <select class="form-select" id="initialDeposit" name="initialDeposit" required>
                            <option value="">Select Range</option>
                            <option value="0-1000">$0 - $1,000</option>
                            <option value="1001-5000">$1,001 - $5,000</option>
                            <option value="5001-10000">$5,001 - $10,000</option>
                            <option value="10001-50000">$10,001 - $50,000</option>
                            <option value="50001-100000">$50,001 - $100,000</option>
                            <option value="100001+">$100,001+</option>
                        </select>
                    </div>
                </div>

                <div class="mt-4">
                    <label class="form-label">Would you like to receive a debit card with your account?</label>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="requestDebitCard" id="requestDebitCardYes" value="yes">
                        <label class="form-check-label" for="requestDebitCardYes">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="requestDebitCard" id="requestDebitCardNo" value="no">
                        <label class="form-check-label" for="requestDebitCardNo">No</label>
                    </div>
                </div>

                <div class="mt-4">
                    <label class="form-label">Would you like to sign up for online banking?</label>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="onlineBanking" id="onlineBankingYes" value="yes" checked>
                        <label class="form-check-label" for="onlineBankingYes">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="onlineBanking" id="onlineBankingNo" value="no">
                        <label class="form-check-label" for="onlineBankingNo">No</label>
                    </div>
                </div>

                <div class="form-footer">
                    <button type="button" class="btn btn-outline-secondary" onclick="prevStep(5)">
                        <i class='bx bx-left-arrow-alt'></i> Back
                    </button>
                    <button type="button" class="btn btn-primary" onclick="nextStep(5)">
                        Continue <i class='bx bx-right-arrow-alt'></i>
                    </button>
                </div>
            </div>

            <!-- Step 6: Security -->
            <div class="form-section" id="step6">
                <h3 class="profile-section-title"><i class='bx bx-lock-alt'></i> Security Setup</h3>
                
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="username" class="form-label">Username</label>
                        <input type="text" class="form-control" id="username" name="username" placeholder="Choose a username" required 
                               pattern="^[a-zA-Z0-9_]{4,20}$">
                        <div class="form-text">4-20 characters, letters, numbers and underscore only</div>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="password" class="form-label">Password</label>
                        <div class="input-group mb-1">
                            <input type="password" class="form-control" id="password" name="password" placeholder="Enter password" required
                                   pattern="^(?=.*[A-Za-z])(?=.*\d)[A-Za-z\d]{8,}$">
                            <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('password')">
                                <i class='bx bx-show'></i>
                            </button>
                        </div>
                        <div class="form-text">Minimum 8 characters, at least one letter and one number</div>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="confirmPassword" class="form-label">Confirm Password</label>
                        <div class="input-group mb-1">
                            <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" placeholder="Confirm password" required>
                            <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('confirmPassword')">
                                <i class='bx bx-show'></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="pin" class="form-label">PIN (4 digits)</label>
                        <input type="password" class="form-control" id="pin" name="pin" placeholder="Enter 4-digit PIN" required
                               pattern="\d{4}" maxlength="4">
                        <div class="form-text">4 digits only - used for transactions and account verification</div>
                    </div>
                </div>

                <div class="mt-4 mb-3">
                    <h4 class="mb-3">Security Questions</h4>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="securityQuestion1" class="form-label">Security Question 1</label>
                            <select class="form-select" id="securityQuestion1" name="securityQuestion1" required>
                                <option value="">Select a question</option>
                                <option value="first_pet">What was the name of your first pet?</option>
                                <option value="birth_city">In what city were you born?</option>
                                <option value="mother_maiden">What is your mother's maiden name?</option>
                                <option value="high_school">What high school did you attend?</option>
                                <option value="first_car">What was the make of your first car?</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="securityAnswer1" class="form-label">Answer</label>

                            <input type="text" class="form-control" id="securityAnswer1" name="securityAnswer1" placeholder="Your answer" required>
                        </div>
                        <div class="col-md-6">
                            <label for="securityQuestion2" class="form-label">Security Question 2</label>
                            <select class="form-select" id="securityQuestion2" name="securityQuestion2" required>
                                <option value="">Select a question</option>
                                <option value="favorite_teacher">Who was your favorite teacher?</option>
                                <option value="first_job">What was your first job?</option>
                                <option value="childhood_friend">What is the name of your childhood best friend?</option>
                                <option value="favorite_food">What is your favorite food?</option>
                                <option value="childhood_hero">Who was your childhood hero?</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="securityAnswer2" class="form-label">Answer</label>
                            <input type="text" class="form-control" id="securityAnswer2" name="securityAnswer2" placeholder="Your answer" required>
                        </div>
                    </div>
                </div>

                <div class="mt-4">
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="enableTwoFactor" name="enableTwoFactor">
                        <label class="form-check-label" for="enableTwoFactor">
                            Enable Two-Factor Authentication
                        </label>
                        <div class="form-text">Recommended for enhanced security. You'll receive a verification code via email or SMS when logging in.</div>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="termsAccept" required>
                        <label class="form-check-label" for="termsAccept">
                            I agree to the <a href="#" data-bs-toggle="modal" data-bs-target="#termsModal">Terms & Conditions</a>
                            and <a href="#" data-bs-toggle="modal" data-bs-target="#privacyModal">Privacy Policy</a>
                        </label>
                    </div>
                </div>

                <div class="form-footer">
                    <button type="button" class="btn btn-outline-secondary" onclick="prevStep(6)">
                        <i class='bx bx-left-arrow-alt'></i> Back
                    </button>
                    <button type="submit" class="btn btn-primary">
                        Create Account <i class='bx bx-check'></i>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Terms Modal -->
<div class="modal fade" id="termsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Terms & Conditions</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <!-- Add your terms content here -->
                <h6>1. Account Terms</h6>
                <p>Terms content goes here...</p>
            </div>
        </div>
    </div>
</div>

<!-- Privacy Modal -->
<div class="modal fade" id="privacyModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Privacy Policy</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <!-- Add your privacy policy content here -->
                <h6>1. Data Collection</h6>
                <p>Privacy policy content goes here...</p>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
// Global variables
let currentStep = 1;
const totalSteps = 6;

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    updateProgressBar();
    initializeValidation();
    setupConditionalFields();
    populateCountries();
});

// Progress bar and step management
function updateProgressBar() {
    document.querySelectorAll('.step-item').forEach((step, index) => {
        if (index + 1 < currentStep) {
            step.classList.add('completed');
            step.classList.remove('active');
        } else if (index + 1 === currentStep) {
            step.classList.add('active');
            step.classList.remove('completed');
        } else {
            step.classList.remove('active', 'completed');
        }
    });
}

function nextStep(step) {
    if (!validateStep(step)) return;

    document.querySelector(`#step${step}`).classList.remove('active');
    document.querySelector(`#step${step + 1}`).classList.add('active');
    currentStep = step + 1;
    updateProgressBar();
    window.scrollTo({ top: 0, behavior: 'smooth' });
}

function prevStep(step) {
    document.querySelector(`#step${step}`).classList.remove('active');
    document.querySelector(`#step${step - 1}`).classList.add('active');
    currentStep = step - 1;
    updateProgressBar();
    window.scrollTo({ top: 0, behavior: 'smooth' });
}

// Setup conditional fields
function setupConditionalFields() {
    // Other bank accounts
    document.querySelectorAll('input[name="hasOtherBankAccounts"]').forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelector('.other-bank-accounts-container').style.display = 
                this.value === 'yes' ? 'block' : 'none';
        });
    });

    // Credit cards
    document.querySelectorAll('input[name="hasOtherCreditCards"]').forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelector('.other-credit-cards-container').style.display = 
                this.value === 'yes' ? 'block' : 'none';
        });
    });

    // Investment accounts
    document.querySelectorAll('input[name="hasInvestmentAccounts"]').forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelector('.investment-accounts-container').style.display = 
                this.value === 'yes' ? 'block' : 'none';
        });
    });

    // 401k accounts
    document.querySelectorAll('input[name="has401k"]').forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelector('.401k-container').style.display = 
                this.value === 'yes' ? 'block' : 'none';
        });
    });

    // Home equity
    document.querySelectorAll('input[name="hasHomeEquity"]').forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelector('.home-equity-container').style.display = 
                this.value === 'yes' ? 'block' : 'none';
        });
    });

    // Business account
    document.querySelectorAll('input[name="hasBusinessAccount"]').forEach(radio => {
                radio.addEventListener('change', function() {
            document.querySelector('.business-account-container').style.display = 
                this.value === 'yes' ? 'block' : 'none';
        });
    });

    // Mortgage
    document.querySelectorAll('input[name="hasMortgage"]').forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelector('.mortgage-container').style.display = 
                this.value === 'yes' ? 'block' : 'none';
        });
    });
}

// Form validation
function initializeValidation() {
    // Password strength validation
    const password = document.querySelector('input[name="password"]');
    const confirmPassword = document.querySelector('input[name="confirmPassword"]');
    
    password?.addEventListener('input', function() {
        validatePassword(this);
    });

    confirmPassword?.addEventListener('input', function() {
        validatePasswordMatch(password, this);
    });

    // Username validation
    const username = document.querySelector('input[name="username"]');
    username?.addEventListener('input', function() {
        validateUsername(this);
    });

    // PIN validation
    const pin = document.querySelector('input[name="pin"]');
    pin?.addEventListener('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '').slice(0, 4);
    });

    // Phone number formatting
    const phoneInputs = document.querySelectorAll('input[type="tel"]');
    phoneInputs.forEach(input => {
        input.addEventListener('input', function() {
            formatPhoneNumber(this);
        });
    });

    // SSN formatting
    const ssnInput = document.getElementById('ssn');
    if (ssnInput) {
        ssnInput.addEventListener('input', function() {
            formatSSN(this);
        });
    }
}

function validateStep(step) {
    const currentSection = document.querySelector(`#step${step}`);
    const requiredFields = currentSection.querySelectorAll('[required]:not(:disabled)');
    let isValid = true;

    requiredFields.forEach(field => {
        if (!field.value) {
            isValid = false;
            highlightError(field);
        } else {
            removeError(field);
        }
    });

    if (!isValid) {
        showError('Please fill in all required fields');
        return false;
    }

    // Additional validation based on step
    switch(step) {
        case 1:
            return validatePersonalInfo();
        case 2:
            return validateAdditionalInfo();
        case 3:
            return validateFinancialProfile();
        case 4:
            return validateDocuments();
        case 5:
            return validateAccountSetup();
        case 6:
            return validateSecurityInfo();
    }

    return true;
}

// Specific validation functions
function validatePersonalInfo() {
    const email = document.querySelector('input[name="email"]');
    const phone = document.querySelector('input[name="phone"]');
    const dob = document.querySelector('input[name="dob"]');
    const ssn = document.querySelector('input[name="ssn"]');

    if (!isValidEmail(email.value)) {
        showError('Please enter a valid email address');
        highlightError(email);
        return false;
    }

    if (!isValidPhone(phone.value)) {
        showError('Please enter a valid phone number');
        highlightError(phone);
        return false;
    }

    if (!isValidAge(dob.value)) {
        showError('You must be 18 or older to register');
        highlightError(dob);
        return false;
    }

    if (ssn && !isValidSSN(ssn.value)) {
        showError('Please enter a valid Social Security Number');
        highlightError(ssn);
        return false;
    }

    return true;
}

function validateAdditionalInfo() {
    return true; // Add specific validation if needed
}

function validateFinancialProfile() {
    return true; // Add specific validation if needed
}

function validateDocuments() {
    // Profile picture is required for the backend
    const profilePicture = document.getElementById('profilePicture');
    
    if (profilePicture.files.length === 0) {
        showError('Please upload a profile picture');
        return false;
    }

    return true;
}

function validateAccountSetup() {
    const accountType = document.querySelector('input[name="accountType"]:checked');
    if (!accountType) {
        showError('Please select an account type');
        return false;
    }
    return true;
}

function validateSecurityInfo() {
    const password = document.querySelector('input[name="password"]');
    const confirmPassword = document.querySelector('input[name="confirmPassword"]');
    const pin = document.querySelector('input[name="pin"]');

    if (!isValidPassword(password.value)) {
        showError('Password must be at least 8 characters with letters and numbers');
        highlightError(password);
        return false;
    }

    if (password.value !== confirmPassword.value) {
        showError('Passwords do not match');
        highlightError(confirmPassword);
        return false;
    }

    if (!isValidPin(pin.value)) {
        showError('PIN must be exactly 4 digits');
        highlightError(pin);
        return false;
    }

    return true;
}

// Helper validation functions
function isValidEmail(email) {
    return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
}

function isValidPhone(phone) {
    const cleaned = phone.replace(/\D/g, '');
    return cleaned.length >= 10;
}

function isValidAge(dob) {
    const age = new Date(new Date() - new Date(dob)).getFullYear() - 1970;
    return age >= 18;
}

function isValidSSN(ssn) {
    const cleaned = ssn.replace(/\D/g, '');
    return cleaned.length === 9;
}

function isValidPassword(password) {
    return /^(?=.*[A-Za-z])(?=.*\d)[A-Za-z\d]{8,}$/.test(password);
}

function isValidPin(pin) {
    return /^\d{4}$/.test(pin);
}

// UI feedback functions
function showError(message) {
    Swal.fire({
        icon: 'error',
        title: 'Validation Error',
        text: message,
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true
    });
}

function highlightError(element) {
    element.classList.add('is-invalid');
    element.addEventListener('input', function() {
        this.classList.remove('is-invalid');
    }, { once: true });
}

function removeError(element) {
    element.classList.remove('is-invalid');
}

// Image preview handling
function previewImage(input, previewId) {
    const preview = document.getElementById(previewId);
    if (!preview) return;
    
    if (input.files && input.files[0]) {
        const file = input.files[0];
        
        if (file.size > 5 * 1024 * 1024) {
            showError('Image must be less than 5MB');
            input.value = '';
            return;
        }

        if (!file.type.startsWith('image/')) {
            showError('Please select an image file');
            input.value = '';
            return;
        }

        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.classList.add('fade-in');
        }
        reader.readAsDataURL(file);
    }
}

// File upload handling
function handleFileSelect(input, fileNameId) {
    const fileNameElement = document.getElementById(fileNameId);
    const previewContainer = document.getElementById(fileNameId).closest('.file-preview');
    
    if (input.files && input.files[0]) {
        const file = input.files[0];
        
        if (file.size > 10 * 1024 * 1024) {
            showError('File must be less than 10MB');
            input.value = '';
            return;
        }

        const allowedTypes = ['application/pdf', 'image/jpeg', 'image/png'];
        if (!allowedTypes.includes(file.type)) {
            showError('Please select a PDF, JPG, or PNG file');
            input.value = '';
            return;
        }

        fileNameElement.textContent = file.name;
        previewContainer.classList.add('show');
    } else {
        fileNameElement.textContent = '';
        previewContainer.classList.remove('show');
    }
}

// Password visibility toggle
function togglePassword(inputId) {
    const passwordInput = document.getElementById(inputId);
    const icon = passwordInput.nextElementSibling.querySelector('i');
    
    if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        icon.classList.replace('bx-show', 'bx-hide');
    } else {
        passwordInput.type = 'password';
        icon.classList.replace('bx-hide', 'bx-show');
    }
}

// Phone number formatting
function formatPhoneNumber(input) {
    let cleaned = input.value.replace(/\D/g, '');
    let formatted = cleaned;
    
    if (cleaned.length > 0) {
        if (cleaned.length <= 3) {
            formatted = cleaned;
        } else if (cleaned.length <= 6) {
            formatted = `(${cleaned.slice(0,3)}) ${cleaned.slice(3)}`;
        } else {
            formatted = `(${cleaned.slice(0,3)}) ${cleaned.slice(3,6)}-${cleaned.slice(6,10)}`;
        }
    }
    
    input.value = formatted;
}

// SSN formatting
function formatSSN(input) {
    let cleaned = input.value.replace(/\D/g, '');
    let formatted = cleaned;
    
    if (cleaned.length > 0) {
        if (cleaned.length <= 3) {
            formatted = cleaned;
        } else if (cleaned.length <= 5) {
            formatted = `${cleaned.slice(0,3)}-${cleaned.slice(3)}`;
        } else {
            formatted = `${cleaned.slice(0,3)}-${cleaned.slice(3,5)}-${cleaned.slice(5,9)}`;
        }
    }
    
    input.value = formatted;
}

// Form submission
function handleSubmit(event) {
    if (!validateStep(currentStep)) {
        event.preventDefault();
        return false;
    }

    if (!document.getElementById('termsAccept').checked) {
        event.preventDefault();
        Swal.fire({
            icon: 'error',
            title: 'Terms & Conditions',
            text: 'Please accept the terms and conditions to continue'
        });
        return false;
    }

    // Show loading state
    Swal.fire({
        title: 'Creating Your Account',
        html: 'Please wait while we process your registration...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    // Let the form submit normally
    return true;
}

// Add country list
function populateCountries() {
    const countrySelect = document.getElementById('country');
    if (!countrySelect) return;
    
    const countries = [
        {code: "US", name: "United States"},
        {code: "CA", name: "Canada"},
        {code: "GB", name: "United Kingdom"},
        {code: "AF", name: "Afghanistan"},
        {code: "AL", name: "Albania"},
        {code: "DZ", name: "Algeria"},
        {code: "AS", name: "American Samoa"},
        {code: "AD", name: "Andorra"},
        {code: "AO", name: "Angola"},
        {code: "AI", name: "Anguilla"},
        {code: "AQ", name: "Antarctica"},
        {code: "AG", name: "Antigua and Barbuda"},
        {code: "AR", name: "Argentina"},
        {code: "AM", name: "Armenia"},
        {code: "AW", name: "Aruba"},
        {code: "AU", name: "Australia"},
        {code: "AT", name: "Austria"},
        {code: "AZ", name: "Azerbaijan"},
        {code: "BS", name: "Bahamas"},
        {code: "BH", name: "Bahrain"},
        {code: "BD", name: "Bangladesh"},
        {code: "BB", name: "Barbados"},
        {code: "BY", name: "Belarus"},
        {code: "BE", name: "Belgium"},
        {code: "BZ", name: "Belize"},
        {code: "BJ", name: "Benin"},
        {code: "BM", name: "Bermuda"},
        {code: "BT", name: "Bhutan"},
        {code: "BO", name: "Bolivia"},
        {code: "BA", name: "Bosnia and Herzegovina"},
        {code: "BW", name: "Botswana"},
        {code: "BV", name: "Bouvet Island"},
        {code: "BR", name: "Brazil"},
        {code: "IO", name: "British Indian Ocean Territory"},
        {code: "BN", name: "Brunei Darussalam"},
        {code: "BG", name: "Bulgaria"},
        {code: "BF", name: "Burkina Faso"},
        {code: "BI", name: "Burundi"},
        {code: "KH", name: "Cambodia"},
        {code: "CM", name: "Cameroon"},
        {code: "CV", name: "Cape Verde"},
        {code: "KY", name: "Cayman Islands"},
        {code: "CF", name: "Central African Republic"},
        {code: "TD", name: "Chad"},
        {code: "CL", name: "Chile"},
        {code: "CN", name: "China"},
        {code: "CX", name: "Christmas Island"},
        {code: "CC", name: "Cocos (Keeling) Islands"},
        {code: "CO", name: "Colombia"},
        {code: "KM", name: "Comoros"},
        {code: "CG", name: "Congo"},
        {code: "CD", name: "Congo, the Democratic Republic of the"},
        {code: "CK", name: "Cook Islands"},
        {code: "CR", name: "Costa Rica"},
        {code: "CI", name: "Cote D'Ivoire"},
        {code: "HR", name: "Croatia"},
        {code: "CU", name: "Cuba"},
        {code: "CY", name: "Cyprus"},
        {code: "CZ", name: "Czech Republic"},
        {code: "DK", name: "Denmark"},
        {code: "DJ", name: "Djibouti"},
        {code: "DM", name: "Dominica"},
        {code: "DO", name: "Dominican Republic"},
        {code: "EC", name: "Ecuador"},
        {code: "EG", name: "Egypt"},
        {code: "SV", name: "El Salvador"},
        {code: "GQ", name: "Equatorial Guinea"},
        {code: "ER", name: "Eritrea"},
        {code: "EE", name: "Estonia"},
        {code: "ET", name: "Ethiopia"},
        {code: "FK", name: "Falkland Islands (Malvinas)"},
        {code: "FO", name: "Faroe Islands"},
        {code: "FJ", name: "Fiji"},
        {code: "FI", name: "Finland"},
        {code: "FR", name: "France"},
        {code: "GF", name: "French Guiana"},
        {code: "PF", name: "French Polynesia"},
        {code: "TF", name: "French Southern Territories"},
        {code: "GA", name: "Gabon"},
        {code: "GM", name: "Gambia"},
        {code: "GE", name: "Georgia"},
        {code: "DE", name: "Germany"},
        {code: "GH", name: "Ghana"},
        {code: "GI", name: "Gibraltar"},
        {code: "GR", name: "Greece"},
        {code: "GL", name: "Greenland"},
        {code: "GD", name: "Grenada"},
        {code: "GP", name: "Guadeloupe"},
        {code: "GU", name: "Guam"},
        {code: "GT", name: "Guatemala"},
        {code: "GN", name: "Guinea"},
        {code: "GW", name: "Guinea-Bissau"},
        {code: "GY", name: "Guyana"},
        {code: "HT", name: "Haiti"},
        {code: "HM", name: "Heard Island and Mcdonald Islands"},
        {code: "VA", name: "Holy See (Vatican City State)"},
        {code: "HN", name: "Honduras"},
        {code: "HK", name: "Hong Kong"},
        {code: "HU", name: "Hungary"},
        {code: "IS", name: "Iceland"},
        {code: "IN", name: "India"},
        {code: "ID", name: "Indonesia"},
        {code: "IR", name: "Iran, Islamic Republic of"},
        {code: "IQ", name: "Iraq"},
        {code: "IE", name: "Ireland"},
        {code: "IL", name: "Israel"},
        {code: "IT", name: "Italy"},
        {code: "JM", name: "Jamaica"},
        {code: "JP", name: "Japan"},
        {code: "JO", name: "Jordan"},
        {code: "KZ", name: "Kazakhstan"},
        {code: "KE", name: "Kenya"},
        {code: "KI", name: "Kiribati"},
        {code: "KP", name: "Korea, Democratic People's Republic of"},
        {code: "KR", name: "Korea, Republic of"},
        {code: "KW", name: "Kuwait"},
        {code: "KG", name: "Kyrgyzstan"},
        {code: "LA", name: "Lao People's Democratic Republic"},
        {code: "LV", name: "Latvia"},
        {code: "LB", name: "Lebanon"},
        {code: "LS", name: "Lesotho"},
        {code: "LR", name: "Liberia"},
        {code: "LY", name: "Libyan Arab Jamahiriya"},
        {code: "LI", name: "Liechtenstein"},

        {code: "LT", name: "Lithuania"},
        {code: "LU", name: "Luxembourg"},
        {code: "MO", name: "Macao"},
        {code: "MK", name: "Macedonia, the Former Yugoslav Republic of"},
        {code: "MG", name: "Madagascar"},
        {code: "MW", name: "Malawi"},
        {code: "MY", name: "Malaysia"},
        {code: "MV", name: "Maldives"},
        {code: "ML", name: "Mali"},
        {code: "MT", name: "Malta"},
        {code: "MH", name: "Marshall Islands"},
        {code: "MQ", name: "Martinique"},
        {code: "MR", name: "Mauritania"},
        {code: "MU", name: "Mauritius"},
        {code: "YT", name: "Mayotte"},
        {code: "MX", name: "Mexico"},
        {code: "FM", name: "Micronesia, Federated States of"},
        {code: "MD", name: "Moldova, Republic of"},
        {code: "MC", name: "Monaco"},
        {code: "MN", name: "Mongolia"},
        {code: "MS", name: "Montserrat"},
        {code: "MA", name: "Morocco"},
        {code: "MZ", name: "Mozambique"},
        {code: "MM", name: "Myanmar"},
        {code: "NA", name: "Namibia"},
        {code: "NR", name: "Nauru"},
        {code: "NP", name: "Nepal"},
        {code: "NL", name: "Netherlands"},
        {code: "AN", name: "Netherlands Antilles"},
        {code: "NC", name: "New Caledonia"},
        {code: "NZ", name: "New Zealand"},
        {code: "NI", name: "Nicaragua"},
        {code: "NE", name: "Niger"},
        {code: "NG", name: "Nigeria"},
        {code: "NU", name: "Niue"},
        {code: "NF", name: "Norfolk Island"},
        {code: "MP", name: "Northern Mariana Islands"},
        {code: "NO", name: "Norway"},
        {code: "OM", name: "Oman"},
        {code: "PK", name: "Pakistan"},
        {code: "PW", name: "Palau"},
        {code: "PS", name: "Palestinian Territory, Occupied"},
        {code: "PA", name: "Panama"},
        {code: "PG", name: "Papua New Guinea"},
        {code: "PY", name: "Paraguay"},
        {code: "PE", name: "Peru"},
        {code: "PH", name: "Philippines"},
        {code: "PN", name: "Pitcairn"},
        {code: "PL", name: "Poland"},
        {code: "PT", name: "Portugal"},
        {code: "PR", name: "Puerto Rico"},
        {code: "QA", name: "Qatar"},
        {code: "RE", name: "Reunion"},
        {code: "RO", name: "Romania"},
        {code: "RU", name: "Russian Federation"},
        {code: "RW", name: "Rwanda"},
        {code: "SH", name: "Saint Helena"},
        {code: "KN", name: "Saint Kitts and Nevis"},
        {code: "LC", name: "Saint Lucia"},
        {code: "PM", name: "Saint Pierre and Miquelon"},
        {code: "VC", name: "Saint Vincent and the Grenadines"},
        {code: "WS", name: "Samoa"},
        {code: "SM", name: "San Marino"},
        {code: "ST", name: "Sao Tome and Principe"},
        {code: "SA", name: "Saudi Arabia"},
        {code: "SN", name: "Senegal"},
        {code: "CS", name: "Serbia and Montenegro"},
        {code: "SC", name: "Seychelles"},
        {code: "SL", name: "Sierra Leone"},
        {code: "SG", name: "Singapore"},
        {code: "SK", name: "Slovakia"},
        {code: "SI", name: "Slovenia"},
        {code: "SB", name: "Solomon Islands"},
        {code: "SO", name: "Somalia"},
        {code: "ZA", name: "South Africa"},
        {code: "GS", name: "South Georgia and the South Sandwich Islands"},
        {code: "ES", name: "Spain"},
        {code: "LK", name: "Sri Lanka"},
        {code: "SD", name: "Sudan"},
        {code: "SR", name: "Suriname"},
        {code: "SJ", name: "Svalbard and Jan Mayen"},
        {code: "SZ", name: "Swaziland"},
        {code: "SE", name: "Sweden"},
        {code: "CH", name: "Switzerland"},
        {code: "SY", name: "Syrian Arab Republic"},
        {code: "TW", name: "Taiwan, Province of China"},
        {code: "TJ", name: "Tajikistan"},
        {code: "TZ", name: "Tanzania, United Republic of"},
        {code: "TH", name: "Thailand"},
        {code: "TL", name: "Timor-Leste"},
        {code: "TG", name: "Togo"},
        {code: "TK", name: "Tokelau"},
        {code: "TO", name: "Tonga"},
        {code: "TT", name: "Trinidad and Tobago"},
        {code: "TN", name: "Tunisia"},
        {code: "TR", name: "Turkey"},
        {code: "TM", name: "Turkmenistan"},
        {code: "TC", name: "Turks and Caicos Islands"},
        {code: "TV", name: "Tuvalu"},
        {code: "UG", name: "Uganda"},
        {code: "UA", name: "Ukraine"},
        {code: "AE", name: "United Arab Emirates"},
        {code: "UM", name: "United States Minor Outlying Islands"},
        {code: "UY", name: "Uruguay"},
        {code: "UZ", name: "Uzbekistan"},
        {code: "VU", name: "Vanuatu"},
        {code: "VE", name: "Venezuela"},
        {code: "VN", name: "Viet Nam"},
        {code: "VG", name: "Virgin Islands, British"},
        {code: "VI", name: "Virgin Islands, U.s."},
        {code: "WF", name: "Wallis and Futuna"},
        {code: "EH", name: "Western Sahara"},
        {code: "YE", name: "Yemen"},
        {code: "ZM", name: "Zambia"},
        {code: "ZW", name: "Zimbabwe"}
    ];
    
    // Clear existing options except the first one
    while (countrySelect.options.length > 1) {
        countrySelect.remove(1);
    }
    
    // Add countries
    countries.forEach(country => {
        const option = document.createElement('option');
        option.value = country.code;
        option.textContent = country.name;
        countrySelect.appendChild(option);
    });
}

// Password validation function
function validatePassword(input) {
    const value = input.value;
    const hasLetter = /[A-Za-z]/.test(value);
    const hasNumber = /\d/.test(value);
    const hasMinLength = value.length >= 8;
    
    if (value && (!hasLetter || !hasNumber || !hasMinLength)) {
        input.classList.add('is-invalid');
        return false;
    } else {
        input.classList.remove('is-invalid');
        return true;
    }
}

// Password match validation
function validatePasswordMatch(password, confirmPassword) {
    if (confirmPassword.value && password.value !== confirmPassword.value) {
        confirmPassword.classList.add('is-invalid');
        return false;
    } else {
        confirmPassword.classList.remove('is-invalid');
        return true;
    }
}

// Username validation
function validateUsername(input) {
    const value = input.value;
    const isValid = /^[a-zA-Z0-9_]{4,20}$/.test(value);
    
    if (value && !isValid) {
        input.classList.add('is-invalid');
        return false;
    } else {
        input.classList.remove('is-invalid');
        return true;
    }
}
</script>
</body>
</html>

