<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BlueSeal Bank System</title>
    
    <!-- CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.0.7/css/boxicons.min.css" rel="stylesheet">
    
    <link href="assets/css/style.css" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
    :root {
        --primary-color: #2563eb;
        --secondary-color: #1e40af;
        --background-color: #f8fafc;
        --sidebar-width: 250px;
    }

    body {
        background: var(--background-color);
        font-family: 'Inter', sans-serif;
    }

 /* Sidebar Styles */
.sidebar {
    position: fixed;
    left: 0;
    top: 0;
    bottom: 0;
    width: var(--sidebar-width);
    background: white;
    box-shadow: 0 0 15px rgba(0,0,0,0.05);
    z-index: 1000;
    transition: all 0.3s ease;
}

.sidebar-header {
    padding: 1.5rem;
    border-bottom: 1px solid #e2e8f0;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.sidebar-brand img {
    height: 40px;
}

.mobile-toggle {
    display: none;
    background: none;
    border: none;
    font-size: 1.5rem;
    color: #64748b;
    cursor: pointer;
}

.sidebar-menu {
    padding: 1.5rem 0;
}

.menu-item {
    padding: 0.75rem 1.5rem;
    display: flex;
    align-items: center;
    color: #64748b;
    text-decoration: none;
    transition: all 0.3s ease;
    border-left: 3px solid transparent;
}

.menu-item:hover {
    background: #f8fafc;
    color: var(--primary-color);
    border-left-color: var(--primary-color);
}

.menu-item.active {
    background: #e8f0fe;
    color: var(--primary-color);
    border-left-color: var(--primary-color);
}

.menu-item i {
    margin-right: 0.75rem;
    font-size: 1.25rem;
}

/* Responsive Sidebar */
@media (max-width: 992px) {
    .sidebar {
        transform: translateX(-100%);
    }

    .sidebar.show {
        transform: translateX(0);
    }

    .mobile-toggle {
        display: block;
    }
}
    .main-content {
        margin-left: var(--sidebar-width);
        padding: 2rem;
    }

    .card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 0 15px rgba(0,0,0,0.05);
        transition: transform 0.3s ease;
    }

    .card:hover {
        transform: translateY(-5px);
    }

    .nav-link {
        border-radius: 10px;
        margin: 5px 15px;
        padding: 12px 15px;
        color: #64748b;
        transition: all 0.3s ease;
    }

    .nav-link:hover, .nav-link.active {
        background: var(--primary-color);
        color: white;
    }

    .nav-link i {
        margin-right: 10px;
    }

    .stat-card {
        background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
        color: white;
    }

    /* Animation classes */
    .fade-in {
        animation: fadeIn 0.5s ease-in;
    }

    .slide-in {
        animation: slideIn 0.5s ease-in;
    }

    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    @keyframes slideIn {
        from { transform: translateX(-20px); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    </style>
</head>
<body>
