<?php
require_once 'config/database.php';

// Create a test reset token
$email = 'mbkoncepts@gmail.com'; // Replace with your email
$token = bin2hex(random_bytes(32));
$code = '123456';
$now = new DateTime();
$expires = (new DateTime())->add(new DateInterval('PT1H')); // 1 hour expiry

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Delete any existing reset requests for this email
    $stmt = $db->prepare("DELETE FROM password_resets WHERE email = ?");
    $stmt->execute([$email]);
    
    // Create new reset request
    $stmt = $db->prepare("INSERT INTO password_resets (email, token, code, created_at, expires_at) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([
        $email,
        $token,
        $code,
        $now->format('Y-m-d H:i:s'),
        $expires->format('Y-m-d H:i:s')
    ]);
    
    // Generate the reset links
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    
    $resetLink1 = "$protocol://$host/reset_password.php?email=" . urlencode($email) . "&token=" . urlencode($token);
    $resetLink2 = "$protocol://$host/test_token.php?email=" . urlencode($email) . "&token=" . urlencode($token);
    
    echo "<h1>Test Reset Links</h1>";
    echo "<p>A test reset token has been created for $email.</p>";
    echo "<p>Token: $token</p>";
    echo "<p>Code: $code</p>";
    echo "<p>Expires: " . $expires->format('Y-m-d H:i:s') . "</p>";
    
    echo "<h2>Links:</h2>";
    echo "<p><a href='$resetLink1' target='_blank'>Reset Password Link</a></p>";
    echo "<p><a href='$resetLink2' target='_blank'>Test Token Link</a></p>";
    
} catch (PDOException $e) {
    echo "<h1>Error</h1>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
}
?>
