<?php
session_start();
require_once 'includes/auth_check.php';

$page = 'international-transfer';
$database = new Database();
$db = $database->getConnection();

// Check if we have wire transfer success data in session
if (!isset($_SESSION['wire_transfer_success'])) {
    header('Location: dashboard.php');
    exit;
}

$transfer = $_SESSION['wire_transfer_success'];

// Get more details from database if needed
$stmt = $db->prepare("
    SELECT wt.*, u.currency as user_currency
    FROM wire_transfers wt
    JOIN users u ON wt.user_id = u.id
    WHERE wt.id = ? AND wt.user_id = ?
");
$stmt->execute([$transfer['id'], $_SESSION['user_id']]);
$wire_transfer = $stmt->fetch(PDO::FETCH_ASSOC);

// If transfer not found, redirect to dashboard
if (!$wire_transfer) {
    unset($_SESSION['wire_transfer_success']);
    header('Location: dashboard.php');
    exit;
}

// Helper function to get country name
function getCountryName($code) {
    $countries = [
        'US' => 'United States', 'GB' => 'United Kingdom', 'CA' => 'Canada', 
        'AU' => 'Australia', 'DE' => 'Germany', 'FR' => 'France', 
        'JP' => 'Japan', 'CN' => 'China', 'IN' => 'India', 
        'SG' => 'Singapore', 'CH' => 'Switzerland', 'ES' => 'Spain', 
        'IT' => 'Italy', 'NL' => 'Netherlands', 'BR' => 'Brazil', 
        'MX' => 'Mexico', 'ZA' => 'South Africa', 'NG' => 'Nigeria', 
        'KE' => 'Kenya', 'AE' => 'United Arab Emirates'
    ];
    return $countries[$code] ?? $code;
}

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<style>
    .success-icon {
        width: 80px;
        height: 80px;
        background-color: #10b981;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1.5rem;
        color: white;
        font-size: 40px;
    }
    
    .transaction-details {
        background-color: #f9fafb;
        border-radius: 0.75rem;
        padding: 1.5rem;
    }
    
    .detail-row {
        display: flex;
        justify-content: space-between;
        padding: 0.75rem 0;
        border-bottom: 1px solid #e5e7eb;
    }
    
    .detail-row:last-child {
        border-bottom: none;
    }
    
    .detail-label {
        color: #6b7280;
        font-weight: 500;
    }
    
    .detail-value {
        font-weight: 600;
        text-align: right;
    }
    
    .processing-badge {
        background-color: #f59e0b;
        color: white;
        padding: 0.25rem 0.75rem;
        border-radius: 9999px;
        font-size: 0.75rem;
        font-weight: 600;
    }
</style>

<div class="main-content">
    <div class="container py-4">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-body p-4 text-center">
                        <div class="success-icon">
                            <i class='bx bx-check'></i>
                        </div>
                        
                        <h2 class="mb-3">Wire Transfer Initiated!</h2>
                        
                        <p class="text-muted mb-2">Your international wire transfer has been initiated and is now being processed.</p>
                        <p class="text-muted mb-4">Please allow 1-5 business days for the funds to reach the recipient's account.</p>
                        
                        <div class="transaction-details mb-4">
                            <div class="detail-row">
                                <div class="detail-label">Transaction ID</div>
                                <div class="detail-value"><?php echo htmlspecialchars($wire_transfer['reference']); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Status</div>
                                <div class="detail-value">
                                    <span class="processing-badge">Processing</span>
                                </div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Date & Time</div>
                                <div class="detail-value"><?php echo date('M j, Y g:i A', strtotime($wire_transfer['created_at'])); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Amount</div>
                                <div class="detail-value"><?php echo htmlspecialchars($wire_transfer['currency']); ?> <?php echo number_format($wire_transfer['amount'], 2); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Fee</div>
                                <div class="detail-value"><?php echo htmlspecialchars($wire_transfer['currency']); ?> <?php echo number_format($wire_transfer['fee'], 2); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Total</div>
                                <div class="detail-value"><?php echo htmlspecialchars($wire_transfer['currency']); ?> <?php echo number_format($wire_transfer['amount'] + $wire_transfer['fee'], 2); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Recipient</div>
                                <div class="detail-value"><?php echo htmlspecialchars($wire_transfer['recipient_name']); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Bank</div>
                                <div class="detail-value"><?php echo htmlspecialchars($wire_transfer['bank_name']); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">SWIFT/BIC</div>
                                <div class="detail-value"><?php echo htmlspecialchars($wire_transfer['swift_code']); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Country</div>
                                <div class="detail-value"><?php echo htmlspecialchars(getCountryName($wire_transfer['country'])); ?></div>
                            </div>
                            <?php if (!empty($wire_transfer['description'])): ?>
                            <div class="detail-row">
                                <div class="detail-label">Description</div>
                                <div class="detail-value"><?php echo htmlspecialchars($wire_transfer['description']); ?></div>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="d-flex justify-content-center gap-3">
                            <a href="dashboard.php" class="btn btn-primary">Back to Dashboard</a>
                            <a href="international-transfer.php" class="btn btn-outline-primary">New Wire Transfer</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php 
// Clear the session data after displaying
unset($_SESSION['wire_transfer_success']);
include 'includes/footer.php'; 
?>
