<?php
session_start();
require_once '../config/database.php';

// Display current user ID
echo "<h2>Current User ID: " . ($_SESSION['user_id'] ?? 'Not set') . "</h2>";

// Create database connection
$database = new Database();
$db = $database->getConnection();

// Check if there are any notifications in the database
try {
    // Count all notifications
    $stmt = $db->query("SELECT COUNT(*) FROM notifications");
    $total_count = $stmt->fetchColumn();
    echo "<p>Total notifications in database: $total_count</p>";
    
    // If user ID is set, count their notifications
    if (isset($_SESSION['user_id'])) {
        $stmt = $db->prepare("SELECT COUNT(*) FROM notifications WHERE user_id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user_count = $stmt->fetchColumn();
        echo "<p>Notifications for current user: $user_count</p>";
        
        // Count unread notifications
        $stmt = $db->prepare("SELECT COUNT(*) FROM notifications WHERE user_id = ? AND is_read = 0");
        $stmt->execute([$_SESSION['user_id']]);
        $unread_count = $stmt->fetchColumn();
        echo "<p>Unread notifications for current user: $unread_count</p>";
        
        // Display all notifications for this user
        $stmt = $db->prepare("SELECT * FROM notifications WHERE user_id = ? ORDER BY created_at DESC");
        $stmt->execute([$_SESSION['user_id']]);
        $notifications = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<h3>User's Notifications:</h3>";
        if (empty($notifications)) {
            echo "<p>No notifications found for this user.</p>";
        } else {
            echo "<table border='1' cellpadding='5'>";
            echo "<tr><th>ID</th><th>Type</th><th>Title</th><th>Message</th><th>Link</th><th>Is Read</th><th>Created At</th></tr>";
            foreach ($notifications as $n) {
                echo "<tr>";
                echo "<td>" . $n['id'] . "</td>";
                echo "<td>" . $n['type'] . "</td>";
                echo "<td>" . $n['title'] . "</td>";
                echo "<td>" . $n['message'] . "</td>";
                echo "<td>" . $n['link'] . "</td>";
                echo "<td>" . ($n['is_read'] ? 'Yes' : 'No') . "</td>";
                echo "<td>" . $n['created_at'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
    }
    
    // Show database structure
    echo "<h3>Notifications Table Structure:</h3>";
    $stmt = $db->query("DESCRIBE notifications");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    foreach ($columns as $col) {
        echo "<tr>";
        foreach ($col as $key => $value) {
            echo "<td>" . $value . "</td>";
        }
        echo "</tr>";
    }
    echo "</table>";
    
} catch (PDOException $e) {
    echo "<p style='color:red'>Database Error: " . $e->getMessage() . "</p>";
}

// Create a test notification
echo "<h3>Create Test Notification:</h3>";
echo "<form method='post'>";
echo "<input type='hidden' name='action' value='create_notification'>";
echo "User ID: <input type='text' name='user_id' value='" . ($_SESSION['user_id'] ?? '') . "'><br>";
echo "Type: <select name='type'>";
echo "<option value='ticket_reply'>Ticket Reply</option>";
echo "<option value='ticket_status'>Ticket Status</option>";
echo "<option value='account'>Account</option>";
echo "<option value='transaction'>Transaction</option>";
echo "</select><br>";
echo "Title: <input type='text' name='title' value='Test Notification'><br>";
echo "Message: <input type='text' name='message' value='This is a test notification'><br>";
echo "Link: <input type='text' name='link' value='#'><br>";
echo "<button type='submit'>Create Notification</button>";
echo "</form>";

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'create_notification') {
    try {
        $user_id = $_POST['user_id'];
        $type = $_POST['type'];
        $title = $_POST['title'];
        $message = $_POST['message'];
        $link = $_POST['link'];
        
        $stmt = $db->prepare("
            INSERT INTO notifications (user_id, type, title, message, link, is_read, created_at)
            VALUES (?, ?, ?, ?, ?, 0, NOW())
        ");
        $stmt->execute([$user_id, $type, $title, $message, $link]);
        
        echo "<p style='color:green'>Test notification created successfully!</p>";
        echo "<p><a href='test_notifications.php'>Refresh to see the new notification</a></p>";
    } catch (PDOException $e) {
        echo "<p style='color:red'>Error creating notification: " . $e->getMessage() . "</p>";
    }
}
?>
