<?php
session_start();
require_once 'includes/auth_check.php';
require_once '../config/database.php';  // Fix the path by adding ../
require_once 'includes/notification_functions.php';

// Set the current page for the sidebar active state
$page = 'notifications';

// Create a database connection
$database = new Database();
$db = $database->getConnection();

// Get all notifications for the current user
try {
    $stmt = $db->prepare("
        SELECT * FROM notifications 
        WHERE user_id = ? 
        ORDER BY created_at DESC
    ");
    $stmt->execute([$_SESSION['user_id']]);
    $notifications = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Mark all as read when viewing the notifications page
    markAllNotificationsAsRead($db, $_SESSION['user_id']);
    
} catch (PDOException $e) {
    $notifications = [];
    $error_message = "Could not retrieve notifications.";
}

// Include the header
include 'includes/header.php';
include 'includes/sidebar.php';
?>

<div class="main-content">
    <div class="container py-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">Notifications</h1>
        </div>
        
        <?php if (isset($error_message)): ?>
            <div class="alert alert-danger"><?php echo $error_message; ?></div>
        <?php endif; ?>
        
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">All Notifications</h5>
            </div>
            <div class="card-body p-0">
                <?php if (empty($notifications)): ?>
                    <div class="text-center py-5">
                        <i class='bx bx-bell-off' style="font-size: 4rem; color: #d1d5db;"></i>
                        <h5 class="mt-3">No Notifications</h5>
                        <p class="text-muted">You don't have any notifications yet.</p>
                    </div>
                <?php else: ?>
                    <div class="list-group list-group-flush">
                        <?php foreach ($notifications as $notification): ?>
                            <a href="<?php echo $notification['link']; ?>" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 align-items-center">
                                    <div class="notification-icon-wrapper notification-<?php echo getNotificationColor($notification['type']); ?> me-3">
                                        <i class='bx <?php echo getNotificationIcon($notification['type']); ?>'></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div class="d-flex w-100 justify-content-between">
                                            <h6 class="mb-1"><?php echo htmlspecialchars($notification['title']); ?></h6>
                                            <small><?php echo date('M j, Y', strtotime($notification['created_at'])); ?></small>
                                        </div>
                                        <p class="mb-1"><?php echo htmlspecialchars($notification['message']); ?></p>
                                        <small class="text-muted"><?php echo date('g:i A', strtotime($notification['created_at'])); ?></small>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
