<?php include 'auth_check.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - BlueSeal Bank</title>
    
    <!-- CSS Dependencies -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../../admin/includes/theme.css.php">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.0.7/css/boxicons.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    
    <style>
        /* Root Variables */
        :root {
            --primary-color: #2563eb;
            --secondary-color: #1e40af;
            --success-color: #059669;
            --danger-color: #dc2626;
            --warning-color: #ea580c;
            --info-color: #0284c7;
            --background-color: #f0f2f5;
            --sidebar-width: 280px;
        }

        /* Base Styles */
        body {
            font-family: 'Poppins', sans-serif;
            background: var(--background-color);
            min-height: 100vh;
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            padding: 2rem;
            transition: all 0.3s ease;
        }

        /* Card Styles */
        .card {
            background: white;
            border-radius: 15px;
            border: none;
            box-shadow: 0 2px 6px rgba(0,0,0,0.05);
            margin-bottom: 1.5rem;
            height: 100%;
        }

        .card-header {
            background: none;
            padding: 1.25rem;
            border-bottom: 1px solid #e5e7eb;
        }

        .card-title {
            margin-bottom: 0;
            font-size: 1.1rem;
            font-weight: 600;
        }

        .card-body {
            padding: 1.25rem;
        }

        /* Stats Widget */
        .stat-widget {
            height: 100%;
            background: white;
            border-radius: 15px;
            padding: 1.5rem;
            transition: all 0.3s ease;
            border: none;
            box-shadow: 0 2px 6px rgba(0,0,0,0.05);
        }

        .stat-widget:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 12px rgba(0,0,0,0.1);
        }

        .stat-widget-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 1rem;
        }

        /* Quick Actions */
        .quick-action-card {
            height: 100%;
            background: white;
            border-radius: 15px;
            padding: 1.5rem;
            text-decoration: none;
            transition: all 0.3s ease;
            border: 1px solid #e5e7eb;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .quick-action-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 12px rgba(0,0,0,0.1);
            border-color: var(--primary-color);
            text-decoration: none;
        }

        .quick-action-icon {
            width: 45px;
            height: 45px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 1rem;
        }

        /* Profile Avatar */
        .profile-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--primary-color);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 1.2rem;
            overflow: hidden;
            border: 2px solid #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .profile-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        /* Progress Bars */
        .progress {
            height: 4px;
            background-color: #e5e7eb;
            border-radius: 2px;
            overflow: hidden;
        }

        .progress-bar {
            transition: width 1s ease;
        }

        /* Table Styles */
        .table > :not(caption) > * > * {
            padding: 1rem;
        }

        .transaction-row {
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .transaction-row:hover {
            background-color: #f8fafc;
            transform: scale(1.01);
        }

        /* Chart Container */
        .chart-container {
            position: relative;
            height: 300px;
            width: 100%;
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .fade-in {
            animation: fadeIn 0.5s ease;
        }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .slide-in-up {
            animation: slideInUp 0.5s ease;
        }

        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 6px;
            height: 6px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 3px;
        }

        ::-webkit-scrollbar-thumb {
            background: #888;
            border-radius: 3px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #555;
        }

        /* Responsive Design */
        @media (max-width: 992px) {
            .main-content {
                margin-left: 0;
            }

            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }
        }


/* Enhanced Balance Widget Styles */
.account-balance-widget {
    background: linear-gradient(to right, #f8f9fa, #e9ecef);
    border-radius: 12px;
    padding: 1.25rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    border: 1px solid rgba(0,0,0,0.05);
}

.balance-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 0.5rem;
}

.balance-amount {
    margin: 0.75rem 0;
}

.balance-amount h3 {
    font-weight: 600;
    margin: 0;
    display: flex;
    align-items: baseline;
}

.currency-symbol {
    font-size: 1rem;
    opacity: 0.8;
    margin-right: 0.25rem;
}

.amount {
    font-size: 1.75rem;
}

.balance-actions {
    display: flex;
    gap: 0.5rem;
}

.account-number {
    background: #f8f9fa;
    border-radius: 8px;
    padding: 0.75rem;
    border: 1px solid #e9ecef;
}

.account-number-text {
    font-family: monospace;
    font-size: 1rem;
    letter-spacing: 1px;
}




/* Mobile Menu Styles */
@media (max-width: 992px) {
    .sidebar {
        position: fixed;
        left: -280px; /* Start off-screen */
        top: 0;
        bottom: 0;
        width: 280px;
        background: white;
        z-index: 1050; /* Higher than other elements */
        transition: all 0.3s ease-in-out;
        box-shadow: none;
    }

    .sidebar.show {
        left: 0;
        box-shadow: 0 0 15px rgba(0,0,0,0.2);
    }

    .main-content {
        margin-left: 0 !important;
    }

    .mobile-toggle {
        display: block !important;
        padding: 0.5rem;
        font-size: 1.5rem;
        line-height: 1;
        background: transparent;
        border: none;
        color: #64748b;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .mobile-toggle:hover {
        color: var(--primary-color);
    }

    /* Add overlay when menu is open */
    .sidebar-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0,0,0,0.5);
        z-index: 1040;
    }

    .sidebar-overlay.show {
        display: block;
    }
}

/* Hide mobile toggle on larger screens */
@media (min-width: 993px) {
    .mobile-toggle {
        display: none !important;
    }
}

/* Notification Styles - ADD THIS NEW SECTION */
.notification-badge {
    position: absolute;
    top: 0;
    right: 0;
    transform: translate(25%, -25%);
    background-color: var(--danger-color);
    color: white;
    border-radius: 50%;
    width: 18px;
    height: 18px;
    font-size: 0.7rem;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
}

.notification-icon {
    position: relative;
    font-size: 1.5rem;
    color: #64748b;
    cursor: pointer;
    transition: all 0.2s ease;
}

.notification-icon:hover {
    color: var(--primary-color);
}

.notifications-dropdown {
    width: 320px;
    max-height: 400px;
    overflow-y: auto;
    padding: 0;
    border: none;
    box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1), 0 4px 6px -2px rgba(0,0,0,0.05);
    border-radius: 0.5rem;
}

.notification-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem;
    border-bottom: 1px solid #e5e7eb;
}

.notification-item {
    padding: 1rem;
    border-bottom: 1px solid #e5e7eb;
    transition: background-color 0.2s ease;
}

.notification-item:hover {
    background-color: #f9fafb;
}

.notification-item.unread {
    background-color: #f0f9ff;
}

.notification-icon-wrapper {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 0.75rem;
}

.notification-primary {
    background-color: rgba(37, 99, 235, 0.1);
    color: #2563eb;
}

.notification-success {
    background-color: rgba(5, 150, 105, 0.1);
    color: #059669;
}

.notification-warning {
    background-color: rgba(234, 88, 12, 0.1);
    color: #ea580c;
}

.notification-danger {
    background-color: rgba(220, 38, 38, 0.1);
    color: #dc2626;
}

.notification-info {
    background-color: rgba(2, 132, 199, 0.1);
    color: #0284c7;
}

.notification-content {
    flex: 1;
}

.notification-title {
    font-weight: 500;
    margin-bottom: 0.25rem;
    font-size: 0.875rem;
}

.notification-text {
    color: #64748b;
    font-size: 0.75rem;
    margin-bottom: 0.25rem;
}

.notification-time {
    color: #94a3b8;
    font-size: 0.75rem;
}

.notification-footer {
    text-align: center;
    padding: 0.75rem;
    border-top: 1px solid #e5e7eb;
}

.notification-footer a {
    color: var(--primary-color);
    font-size: 0.875rem;
    font-weight: 500;
    text-decoration: none;
}

.notification-footer a:hover {
    text-decoration: underline;
}

/* END OF NEW NOTIFICATION STYLES */
        
    </style>
</head>
<!-- Add this button inside your main header/navbar for mobile view -->
<button class="btn d-lg-none" type="button" id="sidebarToggler">
    <i class='bx bx-menu fs-3'></i>
</button>

<body>

<!-- Add this code right after the <body> tag to include notifications -->
<?php
// Include notification functions
require_once 'includes/notification_functions.php';

// Get notifications for the current user
try {
    $unread_count = getUnreadNotificationsCount($db, $_SESSION['user_id']);
    $recent_notifications = getRecentNotifications($db, $_SESSION['user_id']);
} catch (Exception $e) {
    $unread_count = 0;
    $recent_notifications = [];
}
?>

<!-- Add this code where you want the notification dropdown to appear -->
<!-- This would typically go in your top navigation bar -->
<div class="top-navigation">
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center">
            <!-- Left side: Logo or toggle button -->
            <div>
                <!-- Your logo or sidebar toggle button -->
            </div>
            
         
        </div>
    </div>
</div>
