<?php
require_once 'config/database.php';

// Create a test reset token with a much longer expiration
$email = 'mbkoncepts@gmail.com'; // Replace with your email
$token = bin2hex(random_bytes(32));
$code = '123456';
$now = new DateTime();
$expires = (new DateTime())->add(new DateInterval('P7D')); // 7 days expiry

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Delete any existing reset requests for this email
    $stmt = $db->prepare("DELETE FROM password_resets WHERE email = ?");
    $stmt->execute([$email]);
    
    // Create new reset request
    $stmt = $db->prepare("INSERT INTO password_resets (email, token, code, created_at, expires_at) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([
        $email,
        $token,
        $code,
        $now->format('Y-m-d H:i:s'),
        $expires->format('Y-m-d H:i:s')
    ]);
    
    // Generate the reset links
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    
    $resetLink = "$protocol://$host/forgot-password.php?email=" . urlencode($email) . "&token=" . urlencode($token);
    $testLink = "$protocol://$host/test_token.php?email=" . urlencode($email) . "&token=" . urlencode($token);
    
    echo "<h1>Long-Lived Test Reset Links</h1>";
    echo "<p>A test reset token has been created for $email with a 7-day expiration.</p>";
    echo "<p>Token: $token</p>";
    echo "<p>Code: $code</p>";
    echo "<p>Created at: " . $now->format('Y-m-d H:i:s') . "</p>";
    echo "<p>Expires at: " . $expires->format('Y-m-d H:i:s') . "</p>";
    
    echo "<h2>Links:</h2>";
    echo "<p><a href='$resetLink' target='_blank'>Reset Password Link</a></p>";
    echo "<p><a href='$testLink' target='_blank'>Test Token Link</a></p>";
    
} catch (PDOException $e) {
    echo "<h1>Error</h1>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
}
?>
