<?php
// Display server timezone information
echo "<h1>Server Timezone Information</h1>";
echo "<p>Current PHP timezone setting: " . date_default_timezone_get() . "</p>";
echo "<p>Current server time: " . date('Y-m-d H:i:s') . "</p>";

// Check MySQL timezone
try {
    require_once 'config/database.php';
    $database = new Database();
    $db = $database->getConnection();
    
    $stmt = $db->query("SELECT NOW() as mysql_time, @@system_time_zone as system_tz, @@session_time_zone as session_tz");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<h2>MySQL Timezone Information</h2>";
    echo "<p>MySQL current time: " . $result['mysql_time'] . "</p>";
    echo "<p>MySQL system timezone: " . $result['system_tz'] . "</p>";
    echo "<p>MySQL session timezone: " . $result['session_tz'] . "</p>";
    
} catch (Exception $e) {
    echo "<p>Error checking MySQL timezone: " . $e->getMessage() . "</p>";
}

// Show all tokens in the database with their expiration status
try {
    $database = new Database();
    $db = $database->getConnection();
    
    $stmt = $db->query("SELECT * FROM password_resets ORDER BY created_at DESC");
    $tokens = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>Password Reset Tokens</h2>";
    if (count($tokens) > 0) {
        echo "<table border='1'>";
        echo "<tr><th>ID</th><th>Email</th><th>Token (first 10 chars)</th><th>Created At</th><th>Expires At</th><th>Status</th></tr>";
        
        foreach ($tokens as $token) {
            echo "<tr>";
            echo "<td>" . $token['id'] . "</td>";
            echo "<td>" . $token['email'] . "</td>";
            echo "<td>" . substr($token['token'], 0, 10) . "...</td>";
            echo "<td>" . $token['created_at'] . "</td>";
            echo "<td>" . $token['expires_at'] . "</td>";
            
            // Check if token is expired
            $expires = new DateTime($token['expires_at']);
            $now = new DateTime();
            if ($expires > $now) {
                echo "<td style='color:green'>Valid</td>";
            } else {
                echo "<td style='color:red'>Expired</td>";
            }
            
            echo "</tr>";
        }
        
        echo "</table>";
    } else {
        echo "<p>No tokens found in the database.</p>";
    }
    
} catch (Exception $e) {
    echo "<p>Error checking tokens: " . $e->getMessage() . "</p>";
}
?>
