<?php
require_once 'includes/auth_check.php';
$page = 'settings';
require_once '../config/database.php';
require_once 'includes/functions.php';

$database = new Database();
$db = $database->getConnection();

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $testEmail = filter_var($_POST['test_email'], FILTER_SANITIZE_EMAIL);
    
    if (filter_var($testEmail, FILTER_VALIDATE_EMAIL)) {
        // Test user data
        $userData = [
            'email' => $testEmail,
            'first_name' => 'Test',
            'last_name' => 'User',
            'username' => 'testuser',
            'account_number' => '2023123456',
            'account_type' => 'savings'
        ];
        
        $emailSender = getEmailSender($db);
        $emailSent = $emailSender->sendUserRegistrationEmail($userData);
        
        if ($emailSent) {
            $message = '<div class="alert alert-success">Test email sent successfully to ' . htmlspecialchars($testEmail) . '</div>';
        } else {
            $message = '<div class="alert alert-danger">Failed to send test email. Please check your SMTP settings and server logs.</div>';
        }
    } else {
        $message = '<div class="alert alert-danger">Please enter a valid email address.</div>';
    }
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Test Email System</h1>
    
    <?php echo $message; ?>
    
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Send Test Email</h6>
        </div>
        <div class="card-body">
            <p>Use this form to test the email system by sending a sample user registration email.</p>
            
            <form method="post">
                <div class="mb-3">
                    <label for="test_email" class="form-label">Recipient Email</label>
                    <input type="email" class="form-control" id="test_email" name="test_email" required>
                </div>
                
                <button type="submit" class="btn btn-primary">Send Test Email</button>
            </form>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
