<?php
session_start();
require_once '../config/database.php';
require_once 'includes/auth_check.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $btc_instructions = $_POST['btc_instructions'] ?? '';
    $usdt_instructions = $_POST['usdt_instructions'] ?? '';
    
    $database = new Database();
    $db = $database->getConnection();
    
    try {
        // Save BTC instructions
        $stmt = $db->prepare("INSERT INTO settings (setting_key, setting_value) VALUES ('btc_deposit_instructions', ?) 
                             ON DUPLICATE KEY UPDATE setting_value = ?");
        $stmt->execute([$btc_instructions, $btc_instructions]);
        
        // Save USDT instructions
        $stmt = $db->prepare("INSERT INTO settings (setting_key, setting_value) VALUES ('usdt_deposit_instructions', ?) 
                             ON DUPLICATE KEY UPDATE setting_value = ?");
        $stmt->execute([$usdt_instructions, $usdt_instructions]);
        
        $_SESSION['success'] = "Deposit instructions saved successfully.";
    } catch (PDOException $e) {
        $_SESSION['error'] = "Error saving deposit instructions: " . $e->getMessage();
    }
    
    header("Location: crypto_settings.php");
    exit();
}

header("Location: crypto_settings.php");
exit();
