<?php
session_start();
require_once '../includes/admin_auth_check.php';
require_once '../includes/admin_notifications.php';

$page = 'notifications';
$database = new Database();
$db = $database->getConnection();

// Mark notification as read if specified
if (isset($_GET['mark_read']) && is_numeric($_GET['mark_read'])) {
    markAdminNotificationAsRead($db, $_GET['mark_read'], $_SESSION['admin_id']);
    header("Location: notifications.php");
    exit();
}

// Get all notifications for the admin
$stmt = $db->prepare("
    SELECT * FROM admin_notifications 
    WHERE (admin_id = ? OR admin_id IS NULL)
    ORDER BY created_at DESC
");
$stmt->execute([$_SESSION['admin_id']]);
$notifications = $stmt->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<style>
.notification-list {
    background-color: white;
    border-radius: 0.5rem;
    overflow: hidden;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}
.notification-item {
    padding: 1rem;
    border-bottom: 1px solid #e2e8f0;
    transition: background-color 0.2s;
}
.notification-item:last-child {
    border-bottom: none;
}
.notification-item:hover {
    background-color: #f8fafc;
}
.notification-item.unread {
    background-color: #eef2ff;
}
.notification-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
}
.notification-title {
    font-weight: 600;
    margin-bottom: 0.25rem;
}
.notification-message {
    color: #64748b;
    margin-bottom: 0.25rem;
}
.notification-time {
    font-size: 0.75rem;
    color: #94a3b8;
}
.notification-actions {
    display: flex;
    gap: 0.5rem;
}
</style>

<div class="main-content">
    <div class="container-fluid py-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">Notifications</h1>
            <?php if (!empty($notifications)): ?>
                <a href="mark_all_read.php" class="btn btn-light">Mark All as Read</a>
            <?php endif; ?>
        </div>

        <?php if (empty($notifications)): ?>
            <div class="card text-center py-5">
                <div class="card-body">
                    <i class='bx bx-bell-off' style="font-size: 4rem; color: #cbd5e1;"></i>
                    <h5 class="mt-3">No Notifications</h5>
                    <p class="text-muted">You don't have any notifications yet.</p>
                </div>
            </div>
        <?php else: ?>
            <div class="notification-list">
                <?php foreach ($notifications as $notification): ?>
                    <div class="notification-item <?php echo $notification['is_read'] ? '' : 'unread'; ?>">
                        <div class="d-flex">
                            <div class="me-3">
                                <div class="notification-icon bg-<?php echo getAdminNotificationColor($notification['type']); ?>-subtle text-<?php echo getAdminNotificationColor($notification['type']); ?>">
                                    <i class='bx <?php echo getAdminNotificationIcon($notification['type']); ?>'></i>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h5 class="notification-title"><?php echo htmlspecialchars($notification['title']); ?></h5>
                                <p class="notification-message"><?php echo htmlspecialchars($notification['message']); ?></p>
                                <p class="notification-time"><?php echo date('F j, Y g:i A', strtotime($notification['created_at'])); ?></p>
                            </div>
                            <div class="notification-actions">
                                <?php if (!$notification['is_read']): ?>
                                    <a href="notifications.php?mark_read=<?php echo $notification['id']; ?>" class="btn btn-sm btn-light" title="Mark as Read">
                                        <i class='bx bx-check'></i>
                                    </a>
                                <?php endif; ?>
                                <?php if (!empty($notification['link'])): ?>
                                    <a href="<?php echo $notification['link']; ?>" class="btn btn-sm btn-primary" title="View">
                                        <i class='bx bx-right-arrow-alt'></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
