<?php
/**
 * Admin Logout Script - Simplified Version
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Store admin ID for logging (if needed later)
$admin_id = $_SESSION['admin_id'] ?? null;

// Get the path for the session cookie
$params = session_get_cookie_params();
$path = $params['path'];
$domain = $params['domain'];
$secure = $params['secure'];
$httponly = $params['httponly'];

// Clear the session cookie
if (isset($_COOKIE[session_name()])) {
    setcookie(session_name(), '', time() - 86400, $path, $domain, $secure, $httponly);
}

// Clear any "remember me" cookie if you have one
if (isset($_COOKIE['admin_remember'])) {
    setcookie('admin_remember', '', time() - 86400, $path, $domain, $secure, true);
}

// Destroy all session data
$_SESSION = array();
session_destroy();

// Determine where to redirect
$redirect = 'login.php';

// Add a logout message
$query = '?message=logout_success';

// Redirect to login page
header("Location: $redirect$query");
exit;
?>
