<?php
// This file is included by admin pages like dashboard.php, which have already started the session and run auth_check.php
$adminName = isset($_SESSION['admin_name']) ? htmlspecialchars($_SESSION['admin_name']) : 'Admin';
$page = $page ?? 'dashboard'; // Default to 'dashboard' if $page is not set
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - BlueSeal Bank</title>
    
    <!-- CSS Dependencies -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Main Bootstrap CSS -->
<link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
<!-- ... other css ... -->

<!-- DYNAMIC THEME STYLES - ADD THIS LINE -->
<link rel="stylesheet" href="theme.css.php?v=<?php echo time(); ?>">


    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.0.7/css/boxicons.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    
    <!-- Admin Panel Styles -->
    <style>
        :root {
            --primary-color: #4338ca; /* Darker Indigo for Admin */
            --secondary-color: #312e81;
            --background-color: #f8fafc;
            --sidebar-bg: #111827; /* Dark Sidebar */
            --sidebar-text: #9ca3af;
            --sidebar-text-hover: #ffffff;
            --sidebar-active-bg: var(--primary-color);
            --sidebar-width: 260px;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--background-color);
        }
        .wrapper {
            display: flex;
            min-height: 100vh;
        }
        .sidebar {
            width: var(--sidebar-width);
            background-color: var(--sidebar-bg);
            color: var(--sidebar-text);
            position: fixed;
            top: 0;
            left: 0;
            height: 100%;
            display: flex;
            flex-direction: column;
            transition: transform 0.3s ease;
        }
        .sidebar-header {
            padding: 1.5rem;
            text-align: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        .sidebar-header a {
            color: white;
            font-size: 1.5rem;
            font-weight: 600;
            text-decoration: none;
        }
        .sidebar-menu {
            padding: 1rem 0;
            flex-grow: 1;
            overflow-y: auto;
        }
        .menu-item {
            display: flex;
            align-items: center;
            padding: 0.8rem 1.5rem;
            color: var(--sidebar-text);
            text-decoration: none;
            transition: all 0.2s ease;
            border-left: 4px solid transparent;
        }
        .menu-item:hover {
            background-color: rgba(255, 255, 255, 0.05);
            color: var(--sidebar-text-hover);
            border-left-color: var(--primary-color);
        }
        .menu-item.active {
            background-color: var(--sidebar-active-bg);
            color: white;
            font-weight: 500;
            border-left-color: #a78bfa;
        }
        .menu-item i {
            font-size: 1.25rem;
            margin-right: 1rem;
            width: 20px;
            text-align: center;
        }
        .main-content {
            margin-left: var(--sidebar-width);
            width: calc(100% - var(--sidebar-width));
            padding: 2rem;
            transition: all 0.3s ease;
        }
        .topbar {
            background: white;
            padding: 0.75rem 2rem;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .stat-card {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1), 0 2px 4px -2px rgba(0,0,0,0.1);
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1), 0 4px 6px -4px rgba(0,0,0,0.1);
        }
        .stat-card .card-body {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .stat-card .icon-circle {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: white;
        }
        .bg-primary-light { background-color: rgba(79, 70, 229, 0.1); color: var(--primary-color); }
        .bg-success-light { background-color: rgba(22, 163, 74, 0.1); color: #16a34a; }
        .bg-warning-light { background-color: rgba(245, 158, 11, 0.1); color: #f59e0b; }
        .bg-danger-light { background-color: rgba(220, 38, 38, 0.1); color: #dc2626; }

        /* Badge styles for sidebar */
        .menu-item .badge {
            margin-left: auto;
            font-size: 0.7rem;
            padding: 0.25rem 0.5rem;
        }

        @media (max-width: 768px) {
            .sidebar { transform: translateX(-100%); }
            .sidebar.show { transform: translateX(0); }
            .main-content { margin-left: 0; }
            .mobile-toggle { display: block !important; }
        }


/* Add these styles to your header.php file inside the <style> tag */
@media (max-width: 768px) {
    .sidebar { 
        transform: translateX(-100%); 
        z-index: 1050; /* Higher z-index to appear above content */
    }
    .sidebar.show { 
        transform: translateX(0); 
        box-shadow: 0 0 15px rgba(0,0,0,0.2);
    }
    .main-content { 
        margin-left: 0; 
        width: 100%;
        padding: 1rem; /* Smaller padding on mobile */
    }
    .mobile-toggle { 
        display: block !important;
    }
    
    /* Stat cards adjustments */
    .stat-card .card-body {
        padding: 0.75rem;
    }
    .stat-card .icon-circle {
        width: 40px;
        height: 40px;
        font-size: 1.25rem;
    }
    
    /* Table adjustments */
    .table-responsive {
        border: 0;
    }
    
    /* Chart container adjustments */
    .card-body div[style="height: 350px;"] {
        height: 250px !important;
    }
}

/* Make sure the mobile toggle button is visible */
.mobile-toggle {
    display: none;
    cursor: pointer;
}

/* Fix for dropdown menus on mobile */
@media (max-width: 576px) {
    .dropdown-menu {
        position: fixed !important;
        top: auto !important;
        left: 0 !important;
        right: 0 !important;
        width: 100% !important;
        margin: 0 !important;
        border-radius: 0 !important;
        max-height: 80vh !important;
        overflow-y: auto !important;
    }
}



        
    </style>
</head>
<body>
<div class="wrapper">
    <!-- Sidebar -->
    <nav class="sidebar" id="adminSidebar">
        <div class="sidebar-header">
            <a href="dashboard.php"><i class='bx bxs-bank'></i> Admin Panel</a>
        </div>
        <ul class="sidebar-menu list-unstyled">
            <li>
                <a href="dashboard.php" class="menu-item <?php echo ($page == 'dashboard') ? 'active' : ''; ?>">
                    <i class='bx bxs-dashboard'></i><span>Dashboard</span>
                </a>
            </li>
            <li>
                <a href="manage_users.php" class="menu-item <?php echo ($page == 'users') ? 'active' : ''; ?>">
                    <i class='bx bxs-user-detail'></i><span>Manage Users</span>
                </a>
            </li>
            
            <!-- *** MODIFICATION: Transactions Dropdown *** -->
            <li>
                <a href="#transactionsSubmenu" data-bs-toggle="collapse" class="menu-item <?php echo (in_array($page, ['transactions', 'interbank', 'wire', 'btc'])) ? 'active' : ''; ?>">
                    <i class='bx bx-transfer'></i>
                    <span>Transactions</span>
                    <i class='bx bx-chevron-down ms-auto'></i>
                </a>
                <ul class="collapse list-unstyled <?php echo (in_array($page, ['transactions', 'interbank', 'wire', 'btc'])) ? 'show' : ''; ?>" id="transactionsSubmenu">
                    <li>
                        <a href="manage_transactions.php" class="menu-item submenu-item <?php echo ($page == 'transactions') ? 'active' : ''; ?>">
                            <span>All Transactions</span>
                        </a>
                    </li>
                    <li>
                        <a href="interbank_transactions.php" class="menu-item submenu-item <?php echo ($page == 'interbank') ? 'active' : ''; ?>">
                            <span>Interbank</span>
                        </a>
                    </li>
                    <li>
                        <a href="wire_transactions.php" class="menu-item submenu-item <?php echo ($page == 'wire') ? 'active' : ''; ?>">
                            <span>Wire</span>
                        </a>
                    </li>
                     <li>
                        <a href="btc_transactions.php" class="menu-item submenu-item <?php echo ($page == 'btc') ? 'active' : ''; ?>">
                            <span>BTC</span>
                        </a>
                    </li>
                </ul>
            </li>
            <li>
                <a href="credit_debit_user.php" class="menu-item <?php echo ($page == 'credit_debit') ? 'active' : ''; ?>">
                    <i class='bx bx-slider-alt'></i><span>Credit/Debit User</span>
                </a>
            </li>

<!-- NEW: Crypto Management Dropdown -->
<li>
    <a href="#cryptoSubmenu" data-bs-toggle="collapse" class="menu-item <?php echo (in_array($page, ['crypto_deposits', 'crypto_settings'])) ? 'active' : ''; ?>">
        <i class='bx bx-coin-stack'></i>
        <span>Crypto Management</span>
        <?php
        // Get count of pending crypto deposits
        $pending_deposits = 0;
        try {
            if (function_exists('getPendingCryptoDepositsCount')) {
                $pending_deposits = getPendingCryptoDepositsCount($db);
                if ($pending_deposits > 0):
        ?>
            <span class="badge rounded-pill bg-warning ms-auto"><?php echo $pending_deposits; ?></span>
        <?php 
                endif;
            }
        } catch (Exception $e) {
            // Silently handle any errors
            error_log("Error getting pending crypto deposits: " . $e->getMessage());
        }
        ?>
        <i class='bx bx-chevron-down ms-auto'></i>
    </a>
    <ul class="collapse list-unstyled <?php echo (in_array($page, ['crypto_deposits', 'crypto_settings'])) ? 'show' : ''; ?>" id="cryptoSubmenu">
        <li>
            <a href="crypto_deposits.php" class="menu-item submenu-item <?php echo ($page == 'crypto_deposits') ? 'active' : ''; ?>">
                <span>Crypto Deposits</span>
                <?php if (isset($pending_deposits) && $pending_deposits > 0): ?>
                    <span class="badge rounded-pill bg-warning ms-auto"><?php echo $pending_deposits; ?></span>
                <?php endif; ?>
            </a>
        </li>
        <li>
            <a href="crypto_settings.php" class="menu-item submenu-item <?php echo ($page == 'crypto_settings') ? 'active' : ''; ?>">
                <span>Wallet Settings</span>
            </a>
        </li>
    </ul>
</li>


            
            
            <!-- FIXED: Support Tickets Menu Item -->
            <li>
                <a href="tickets.php" class="menu-item <?php echo ($page == 'tickets') ? 'active' : ''; ?>">
                    <i class='bx bx-support'></i>
                    <span>Support Tickets</span>
                    <?php
                    // Get count of open tickets
                    try {
                        $stmt = $db->prepare("SELECT COUNT(*) FROM tickets WHERE status = 'open'");
                        $stmt->execute();
                        $open_tickets = $stmt->fetchColumn();
                        if ($open_tickets > 0):
                    ?>
                        <span class="badge rounded-pill bg-danger ms-auto"><?php echo $open_tickets; ?></span>
                    <?php 
                        endif;
                    } catch (Exception $e) {
                        // Silently handle any errors
                    }
                    ?>
                </a>
            </li>

            <li>
                <a href="settings.php" class="menu-item <?php echo ($page == 'settings') ? 'active' : ''; ?>">
                    <i class='bx bxs-cog'></i><span>Settings</span>
                </a>
            </li>
        </ul>
        <div class="sidebar-footer p-3 border-top border-secondary-subtle">
             <a href="logout.php" class="menu-item text-danger">
                <i class='bx bx-log-out'></i><span>Logout</span>
            </a>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Topbar -->
        <header class="topbar rounded">
            <button class="btn btn-light d-md-none mobile-toggle" id="sidebarToggleBtn">
                <i class='bx bx-menu'></i>
            </button>
            <h1 class="h4 mb-0 text-gray-800">Welcome, <?php echo $adminName; ?>!</h1>
            <div class="d-flex align-items-center">
                <div id="realTimeClock" class="text-muted me-3 d-none d-lg-block"></div>
                <?php
                require_once 'admin_notifications.php';
                try {
                    $unread_count = getUnreadAdminNotificationsCount($db, $_SESSION['admin_id']);
                    $recent_notifications = getRecentAdminNotifications($db, $_SESSION['admin_id']);
                } catch (Exception $e) {
                    $unread_count = 0;
                    $recent_notifications = [];
                }
                ?>

                <!-- Notifications Dropdown -->
                <div class="dropdown me-3">
                    <a class="nav-link dropdown-toggle position-relative" href="#" role="button" id="notificationsDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class='bx bx-bell fs-4'></i>
                        <?php if ($unread_count > 0): ?>
                            <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                <?php echo $unread_count; ?>
                            </span>
                        <?php endif; ?>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end p-0" aria-labelledby="notificationsDropdown" style="width: 320px; max-height: 400px; overflow-y: auto;">
                        <div class="d-flex justify-content-between align-items-center p-3 border-bottom">
                            <h6 class="mb-0">Notifications</h6>
                            <?php if ($unread_count > 0): ?>
                                <a href="mark_all_read.php" class="text-decoration-none small">Mark all as read</a>
                            <?php endif; ?>
                        </div>
                        <?php if (empty($recent_notifications)): ?>
                            <div class="p-3 text-center text-muted">
                                <i class='bx bx-bell-off fs-4 mb-2'></i>
                                <p class="mb-0">No notifications yet</p>
                            </div>
                        <?php else: ?>
                            <?php foreach ($recent_notifications as $notification): ?>
                                <a href="<?php echo $notification['link']; ?>" class="dropdown-item p-3 border-bottom <?php echo $notification['is_read'] ? '' : 'bg-light'; ?>">
                                    <div class="d-flex">
                                        <div class="me-3">
                                            <div class="avatar avatar-sm bg-<?php echo getAdminNotificationColor($notification['type']); ?>-subtle text-<?php echo getAdminNotificationColor($notification['type']); ?> rounded-circle">
                                                <i class='bx <?php echo getAdminNotificationIcon($notification['type']); ?>'></i>
                                            </div>
                                        </div>
                                        <div>
                                            <h6 class="mb-1 fs-sm"><?php echo htmlspecialchars($notification['title']); ?></h6>
                                            <p class="mb-1 small text-muted"><?php echo htmlspecialchars($notification['message']); ?></p>
                                            <p class="mb-0 small text-muted"><?php echo date('M j, g:i A', strtotime($notification['created_at'])); ?></p>
                                        </div>
                                    </div>
                                </a>
                            <?php endforeach; ?>
                            <div class="p-2 text-center border-top">
                                <a href="notifications.php" class="btn btn-sm btn-link text-decoration-none">View All</a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="dropdown">
                    <a href="#" class="d-flex align-items-center text-dark text-decoration-none dropdown-toggle" data-bs-toggle="dropdown">
                        <div class="icon-circle bg-primary-light me-2">
                            <i class='bx bxs-user'></i>
                        </div>
                        <span class="d-none d-sm-inline"><?php echo $adminName; ?></span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end shadow">
                        <li><a class="dropdown-item" href="profile.php"><i class='bx bx-user me-2'></i>Profile</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-danger" href="logout.php"><i class='bx bx-log-out me-2'></i>Logout</a></li>
                    </ul>
                </div>
            </div>
        </header>
