<?php
// admin/includes/footer.php
?>
    </div> <!-- End Main Content -->
</div> <!-- End Wrapper -->

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Real-time Clock
    const clockElement = document.getElementById('realTimeClock');
    if (clockElement) {
        function updateClock() {
            const now = new Date();
            const options = { year: 'numeric', month: 'long', day: 'numeric', hour: '2-digit', minute: '2-digit' };
            clockElement.textContent = now.toLocaleDateString('en-US', options);
        }
        setInterval(updateClock, 1000);
        updateClock();
    }

    // Mobile Sidebar Toggle - Improved version
    const sidebarToggleBtn = document.getElementById('sidebarToggleBtn');
    const adminSidebar = document.getElementById('adminSidebar');
    const mainContent = document.querySelector('.main-content');
    
    if (sidebarToggleBtn && adminSidebar) {
        sidebarToggleBtn.addEventListener('click', function(e) {
            e.stopPropagation(); // Prevent event from bubbling up
            adminSidebar.classList.toggle('show');
        });
        
        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(e) {
            if (window.innerWidth <= 768 && 
                adminSidebar.classList.contains('show') && 
                !adminSidebar.contains(e.target) && 
                e.target !== sidebarToggleBtn) {
                adminSidebar.classList.remove('show');
            }
        });
    }

    // --- Chart.js Analytics ---
    // 1. User Growth Line Chart
    const growthCtx = document.getElementById('userGrowthChart');
    if (growthCtx) {
        try {
            new Chart(growthCtx, {
                type: 'line',
                data: {
                    labels: <?php echo $userGrowthLabels ?? '[]'; ?>,
                    datasets: [{
                        label: 'New Users',
                        data: <?php echo $userGrowthValues ?? '[]'; ?>,
                        borderColor: 'rgba(79, 70, 229, 1)',
                        backgroundColor: 'rgba(79, 70, 229, 0.1)',
                        fill: true,
                        tension: 0.4,
                        borderWidth: 2
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0 // Ensure whole numbers for user counts
                            }
                        }
                    },
                    plugins: {
                        legend: { display: false }
                    }
                }
            });
        } catch (e) {
            console.error("Error initializing user growth chart:", e);
        }
    }

    // 2. User Status Doughnut Chart
    const statusCtx = document.getElementById('userStatusChart');
    if (statusCtx) {
        try {
            new Chart(statusCtx, {
                type: 'doughnut',
                data: {
                    labels: <?php echo $statusLabels ?? '[]'; ?>,
                    datasets: [{
                        label: 'User Status',
                        data: <?php echo $statusValues ?? '[]'; ?>,
                        backgroundColor: [
                            'rgba(22, 163, 74, 0.7)',  // Active (Success)
                            'rgba(245, 158, 11, 0.7)', // Pending (Warning)
                            'rgba(220, 38, 38, 0.7)',  // Suspended (Danger)
                            'rgba(107, 114, 128, 0.7)' // Closed (Gray)
                        ],
                        borderColor: '#fff',
                        borderWidth: 2,
                        hoverOffset: 8
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                padding: 20,
                                boxWidth: 12,
                                font: { size: 14 }
                            }
                        }
                    }
                }
            });
        } catch (e) {
            console.error("Error initializing user status chart:", e);
        }
    }
});
</script>

<!-- Additional Mobile Styles -->
<style>
@media (max-width: 768px) {
    .sidebar { 
        transform: translateX(-100%); 
        z-index: 1050; /* Higher z-index to appear above content */
    }
    .sidebar.show { 
        transform: translateX(0); 
        box-shadow: 0 0 15px rgba(0,0,0,0.2);
    }
    .main-content { 
        margin-left: 0; 
        width: 100%;
        padding: 1rem; /* Smaller padding on mobile */
    }
    .mobile-toggle { 
        display: block !important;
    }
    
    /* Stat cards adjustments */
    .stat-card .card-body {
        padding: 0.75rem;
    }
    .stat-card .icon-circle {
        width: 40px;
        height: 40px;
        font-size: 1.25rem;
    }
    
    /* Table adjustments */
    .table-responsive {
        border: 0;
    }
    
    /* Chart container adjustments */
    .card-body div[style="height: 350px;"] {
        height: 250px !important;
    }
    
    /* Dropdown menu fixes */
    .dropdown-menu {
        position: absolute !important;
        max-height: 80vh;
        overflow-y: auto;
    }
}
</style>

</body>
</html>
