<?php
// admin/includes/auth_check.php

// If a session is not already active, start one.
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if the required admin session variables are set. If not, redirect to the login page.
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    // Redirect to the admin login page
    header('Location: login.php');
    exit; // Crucial to stop the script from running further
}

// If we reach this point, the user is a verified admin.
?>
