<?php
require_once 'includes/auth_check.php';
require_once '../config/database.php';

// Get parameters
$transfer_id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$status = isset($_POST['status']) ? $_POST['status'] : '';

if (!$transfer_id || !in_array($status, ['pending', 'hold', 'approved', 'rejected'])) {
    echo "Invalid parameters";
    exit;
}

$database = new Database();
$db = $database->getConnection();

try {
    // Update the status directly
    $stmt = $db->prepare("UPDATE wire_transfers SET status = ? WHERE id = ?");
    $stmt->execute([$status, $transfer_id]);
    
    echo "Status updated successfully to '$status'";
    echo "<p><a href='wire_status_check.php?id=$transfer_id'>Check Status</a></p>";
    echo "<p><a href='wire_transactions.php'>Back to Wire Transactions</a></p>";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
