<?php
// This file will attempt to update the status directly using mysqli
// No PDO, no transactions, just a direct update

// Database credentials - replace with your actual credentials
$host = 'localhost';
$username = 'your_db_username';
$password = 'your_db_password';
$database = 'your_db_name';

// Get transfer ID from query string
$transfer_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$new_status = isset($_GET['status']) ? $_GET['status'] : 'hold';

if (!$transfer_id) {
    die("No transfer ID provided");
}

// Create connection
$conn = new mysqli($host, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "<h2>Direct Update Test</h2>";
echo "<p>Transfer ID: $transfer_id</p>";
echo "<p>New Status: $new_status</p>";

// Get current status
$result = $conn->query("SELECT status FROM wire_transfers WHERE id = $transfer_id");
if ($result && $row = $result->fetch_assoc()) {
    $current_status = $row['status'];
    echo "<p>Current Status: '$current_status'</p>";
} else {
    echo "<p>Error getting current status: " . $conn->error . "</p>";
}

// Try to update just the status
echo "<h3>Method 1: Update Just Status</h3>";
$sql1 = "UPDATE wire_transfers SET status = '$new_status' WHERE id = $transfer_id";
if ($conn->query($sql1) === TRUE) {
    echo "<p>Status updated successfully</p>";
} else {
    echo "<p>Error updating status: " . $conn->error . "</p>";
}

// Check if it worked
$result = $conn->query("SELECT status FROM wire_transfers WHERE id = $transfer_id");
if ($result && $row = $result->fetch_assoc()) {
    $new_status1 = $row['status'];
    echo "<p>Status after update: '$new_status1'</p>";
} else {
    echo "<p>Error getting updated status: " . $conn->error . "</p>";
}

// Try to update all hold-related fields
echo "<h3>Method 2: Update All Hold Fields</h3>";
$sql2 = "UPDATE wire_transfers SET status = '$new_status', hold_reason = 'Test reason', hold_by = 1, hold_at = NOW() WHERE id = $transfer_id";
if ($conn->query($sql2) === TRUE) {
    echo "<p>All fields updated successfully</p>";
} else {
    echo "<p>Error updating all fields: " . $conn->error . "</p>";
}

// Check if it worked
$result = $conn->query("SELECT status, hold_reason, hold_by, hold_at FROM wire_transfers WHERE id = $transfer_id");
if ($result && $row = $result->fetch_assoc()) {
    echo "<p>Status after update: '" . $row['status'] . "'</p>";
    echo "<p>Hold Reason: '" . $row['hold_reason'] . "'</p>";
    echo "<p>Hold By: '" . $row['hold_by'] . "'</p>";
    echo "<p>Hold At: '" . $row['hold_at'] . "'</p>";
} else {
    echo "<p>Error getting updated fields: " . $conn->error . "</p>";
}

// Try to update with a different value
echo "<h3>Method 3: Update with Different Value</h3>";
$sql3 = "UPDATE wire_transfers SET status = 'on_hold' WHERE id = $transfer_id";
if ($conn->query($sql3) === TRUE) {
    echo "<p>Status updated to 'on_hold' successfully</p>";
} else {
    echo "<p>Error updating status to 'on_hold': " . $conn->error . "</p>";
}

// Check if it worked
$result = $conn->query("SELECT status FROM wire_transfers WHERE id = $transfer_id");
if ($result && $row = $result->fetch_assoc()) {
    $new_status3 = $row['status'];
    echo "<p>Status after update: '$new_status3'</p>";
} else {
    echo "<p>Error getting updated status: " . $conn->error . "</p>";
}

// Try to update with a completely different approach
echo "<h3>Method 4: Insert and Update</h3>";
$conn->query("CREATE TEMPORARY TABLE temp_status (id INT, status VARCHAR(50))");
$conn->query("INSERT INTO temp_status (id, status) VALUES ($transfer_id, '$new_status')");
$sql4 = "UPDATE wire_transfers w JOIN temp_status t ON w.id = t.id SET w.status = t.status";
if ($conn->query($sql4) === TRUE) {
    echo "<p>Status updated via temporary table successfully</p>";
} else {
    echo "<p>Error updating via temporary table: " . $conn->error . "</p>";
}

// Check if it worked
$result = $conn->query("SELECT status FROM wire_transfers WHERE id = $transfer_id");
if ($result && $row = $result->fetch_assoc()) {
    $new_status4 = $row['status'];
    echo "<p>Status after update: '$new_status4'</p>";
} else {
    echo "<p>Error getting updated status: " . $conn->error . "</p>";
}

// Check for triggers
echo "<h3>Database Triggers</h3>";
$result = $conn->query("SHOW TRIGGERS WHERE `Table` = 'wire_transfers'");
if ($result && $result->num_rows > 0) {
    echo "<table border='1'>";
    echo "<tr><th>Trigger</th><th>Event</th><th>Statement</th><th>Timing</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['Trigger'] . "</td>";
        echo "<td>" . $row['Event'] . "</td>";
        echo "<td>" . $row['Statement'] . "</td>";
        echo "<td>" . $row['Timing'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>No triggers found for wire_transfers table.</p>";
}

// Show table structure
echo "<h3>Table Structure</h3>";
$result = $conn->query("DESCRIBE wire_transfers");
if ($result) {
    echo "<table border='1'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>Error getting table structure: " . $conn->error . "</p>";
}

// Close connection
$conn->close();
?>
