<?php
session_start();
require_once '../../config/database.php';
require_once '../includes/auth_check.php';

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'Deposit ID is required.']);
    exit();
}

$deposit_id = $_GET['id'];
$database = new Database();
$db = $database->getConnection();

try {
    // Get deposit details with user information
    $stmt = $db->prepare("
        SELECT cd.*, u.first_name, u.last_name, u.email, u.account_number 
        FROM crypto_deposits cd
        LEFT JOIN users u ON cd.user_id = u.id
        WHERE cd.id = ?
    ");
    $stmt->execute([$deposit_id]);
    $deposit = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$deposit) {
        echo json_encode(['success' => false, 'message' => 'Deposit not found.']);
        exit();
    }
    
    echo json_encode(['success' => true, 'deposit' => $deposit]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'An error occurred: ' . $e->getMessage()]);
}
